/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.network.packets;

import forestry.api.genetics.GeneticCapabilities;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;

public class PacketFilterChangeRule
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final Direction facing;
    private final IFilterRuleType rule;

    public PacketFilterChangeRule(BlockPos pos, Direction facing, IFilterRuleType rule) {
        this.pos = pos;
        this.facing = facing;
        this.rule = rule;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeShort(this.facing.func_176745_a());
        data.writeShort(AlleleManager.filterRegistry.getId(this.rule));
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.FILTER_CHANGE_RULE;
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, ServerPlayerEntity player) {
            BlockPos pos = data.func_179259_c();
            Direction facing = Direction.func_82600_a((int)data.readShort());
            IFilterRuleType rule = AlleleManager.filterRegistry.getRuleOrDefault(data.readShort());
            LazyOptional<IFilterLogic> logic = TileUtil.getInterface(player.field_70170_p, pos, GeneticCapabilities.FILTER_LOGIC, null);
            logic.ifPresent(l -> {
                if (l.setRule(facing, rule)) {
                    l.getNetworkHandler().sendToPlayers((IFilterLogic)l, player.func_71121_q(), (PlayerEntity)player);
                }
            });
        }
    }
}

