/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.base.Preconditions;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackInterface;
import forestry.core.proxy.Proxies;
import forestry.storage.BackpackFilterNaturalist;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemBackpackNaturalist;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;

public class BackpackInterface
implements IBackpackInterface {
    @Override
    public Item createBackpack(IBackpackDefinition definition, EnumBackpackType type) {
        Preconditions.checkNotNull((Object)definition, (Object)"definition must not be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type must not be null");
        Preconditions.checkArgument((type != EnumBackpackType.NATURALIST ? 1 : 0) != 0, (Object)"type must not be NATURALIST. Use createNaturalistBackpack instead.");
        ItemBackpack backpack = new ItemBackpack(definition, type);
        Proxies.common.registerItem(backpack);
        return backpack;
    }

    @Override
    public Item createNaturalistBackpack(IBackpackDefinition definition, String rootUid, ItemGroup tab) {
        Preconditions.checkNotNull((Object)definition, (Object)"definition must not be null");
        Preconditions.checkNotNull((Object)rootUid, (Object)"rootUid must not be null");
        ItemBackpackNaturalist backpack = new ItemBackpackNaturalist(rootUid, definition, tab);
        Proxies.common.registerItem(backpack);
        return backpack;
    }

    @Override
    public Predicate<ItemStack> createNaturalistBackpackFilter(String speciesRootUid) {
        return new BackpackFilterNaturalist(speciesRootUid);
    }
}

