/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import forestry.core.models.ClientManager;
import forestry.core.utils.ResourceUtil;
import forestry.storage.features.CrateItems;
import forestry.storage.items.ItemCrated;
import forestry.storage.models.CrateBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class CrateModel
implements IModelGeometry<CrateModel> {
    private static final String CUSTOM_CRATES = "forestry:item/crates/";
    private static List<BakedQuad> bakedQuads = new LinkedList<BakedQuad>();
    private final ItemCrated crated;
    private final ItemStack contained;

    public static void clearCachedQuads() {
        bakedQuads.clear();
    }

    public CrateModel(ItemCrated crated) {
        this.crated = crated;
        this.contained = crated.getContained();
    }

    @Nullable
    private IBakedModel getCustomContentModel(ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform) {
        IUnbakedModel model;
        ResourceLocation registryName = this.crated.getRegistryName();
        if (registryName == null) {
            return null;
        }
        String containedName = registryName.func_110623_a().replace("crated.", "");
        ResourceLocation location = new ResourceLocation(CUSTOM_CRATES + containedName);
        if (!ResourceUtil.resourceExists(new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json"))) {
            return null;
        }
        try {
            model = ModelLoader.instance().func_209597_a(location);
        }
        catch (Exception e) {
            return null;
        }
        return model.func_225613_a_(bakery, spriteGetter, transform, location);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        CrateBakedModel model;
        IBakedModel bakedModel;
        if (bakedQuads.isEmpty() && (bakedModel = bakery.getBakedModel((ResourceLocation)new ModelResourceLocation("forestry:crate-filled", "inventory"), transform, spriteGetter)) != null) {
            for (BakedQuad quad : bakedModel.getQuads(null, null, new Random(0L), (IModelData)EmptyModelData.INSTANCE)) {
                bakedQuads.add(new BakedQuad(quad.func_178209_a(), 100, quad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_()));
            }
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(bakedQuads);
        IBakedModel contentModel = this.getCustomContentModel(bakery, spriteGetter, transform);
        if (contentModel == null) {
            model = new CrateBakedModel(quads, this.contained);
        } else {
            quads.addAll(contentModel.getQuads(null, null, new Random(0L), (IModelData)EmptyModelData.INSTANCE));
            model = new CrateBakedModel(quads);
        }
        return new PerspectiveMapWrapper((IBakedModel)model, ClientManager.getInstance().getDefaultItemState());
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return Collections.emptyList();
    }

    public static class Loader
    implements IModelLoader {
        public static final ResourceLocation LOCATION = new ResourceLocation("forestry", "crate-filled");

        public void func_195410_a(IResourceManager resourceManager) {
            CrateModel.clearCachedQuads();
        }

        public IModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ResourceLocation registryName = new ResourceLocation("forestry", JSONUtils.func_151200_h((JsonObject)modelContents, (String)"variant"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
            if (!(item instanceof ItemCrated)) {
                return ModelLoaderRegistry.getModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("forestry", CrateItems.CRATE.getIdentifier()), "inventory"), (JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
            }
            ItemCrated crated = (ItemCrated)item;
            return new CrateModel(crated);
        }
    }
}

