/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotCrafter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.worktable.features.WorktableContainers;
import forestry.worktable.inventory.CraftingInventoryForestry;
import forestry.worktable.network.packets.PacketWorktableMemoryUpdate;
import forestry.worktable.network.packets.PacketWorktableRecipeRequest;
import forestry.worktable.network.packets.PacketWorktableRecipeUpdate;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.tiles.TileWorktable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerWorktable
extends ContainerTile<TileWorktable>
implements IContainerCrafting,
IGuiSelectable {
    private final CraftingInventoryForestry craftMatrix = new CraftingInventoryForestry(this);
    private long lastMemoryUpdate;
    private boolean craftMatrixChanged = false;

    public static ContainerWorktable fromNetwork(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        TileWorktable worktable = TileUtil.getTile((IBlockReader)playerInv.field_70458_d.field_70170_p, extraData.func_179259_c(), TileWorktable.class);
        return new ContainerWorktable(windowId, playerInv, worktable);
    }

    public ContainerWorktable(int windowId, PlayerInventory inv, TileWorktable tile) {
        super(windowId, WorktableContainers.WORKTABLE.containerType(), inv, tile, 8, 136);
        int i;
        IInventory craftingDisplay = tile.getCraftingDisplay();
        IInventoryAdapter internalInventory = tile.getInternalInventory();
        for (i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)internalInventory, 0 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.func_75146_a(new SlotCraftMatrix(this, craftingDisplay, k1 + l * 3, 11 + k1 * 18, 20 + l * 18));
            }
        }
        this.func_75146_a(new SlotCrafter(inv.field_70458_d, this.craftMatrix, craftingDisplay, tile, 9, 77, 38));
        for (i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            this.onCraftMatrixChanged(tile.getCraftingDisplay(), i);
        }
    }

    @Override
    public void func_75142_b() {
        if (this.craftMatrixChanged) {
            this.craftMatrixChanged = false;
            ((TileWorktable)this.tile).setCurrentRecipe(this.craftMatrix);
            this.sendPacketToListeners(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
        }
        super.func_75142_b();
        if (this.lastMemoryUpdate != ((TileWorktable)this.tile).getMemory().getLastUpdate()) {
            this.lastMemoryUpdate = ((TileWorktable)this.tile).getMemory().getLastUpdate();
            this.sendPacketToListeners(new PacketWorktableMemoryUpdate((TileWorktable)this.tile));
        }
    }

    public void updateCraftMatrix() {
        IInventory crafting = ((TileWorktable)this.tile).getCraftingDisplay();
        for (int i = 0; i < crafting.func_70302_i_(); ++i) {
            this.onCraftMatrixChanged(crafting, i);
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory, int slot) {
        ItemStack currentStack;
        if (slot >= this.craftMatrix.func_70302_i_()) {
            return;
        }
        ItemStack stack = iinventory.func_70301_a(slot);
        if (!ItemStackUtil.isIdenticalItem(stack, currentStack = this.craftMatrix.func_70301_a(slot))) {
            this.craftMatrix.func_70299_a(slot, stack.func_77946_l());
        }
    }

    public void func_75130_a(IInventory iinventory) {
        this.craftMatrixChanged = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clearRecipe() {
        ContainerWorktable.sendRecipeClick(-1, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendRecipeClick(int mouseButton, int recipeIndex) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(mouseButton, recipeIndex));
    }

    @Override
    public void handleSelectionRequest(ServerPlayerEntity player, int primary, int secondary) {
        switch (primary) {
            case -1: {
                ((TileWorktable)this.tile).clearCraftMatrix();
                this.updateCraftMatrix();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 0: {
                ((TileWorktable)this.tile).chooseRecipeMemory(secondary);
                this.updateCraftMatrix();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 1: {
                long time = player.field_70170_p.func_82737_E();
                RecipeMemory memory = ((TileWorktable)this.tile).getMemory();
                memory.toggleLock(time, secondary);
                break;
            }
            case 100: {
                ((TileWorktable)this.tile).choosePreviousConflictRecipe();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 101: {
                ((TileWorktable)this.tile).chooseNextConflictRecipe();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendWorktableRecipeRequest(MemorizedRecipe recipe) {
        NetworkUtil.sendToServer(new PacketWorktableRecipeRequest((TileWorktable)this.tile, recipe));
    }
}

