/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.worktable.gui.ContainerWorktable;
import forestry.worktable.network.packets.PacketWorktableRecipeUpdate;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.tiles.TileWorktable;
import java.io.IOException;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class PacketWorktableRecipeRequest
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final MemorizedRecipe recipe;

    public PacketWorktableRecipeRequest(TileWorktable worktable, MemorizedRecipe recipe) {
        this.pos = worktable.func_174877_v();
        this.recipe = recipe;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.WORKTABLE_RECIPE_REQUEST;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        this.recipe.writeData(data);
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, ServerPlayerEntity player) throws IOException {
            BlockPos pos = data.func_179259_c();
            MemorizedRecipe recipe = new MemorizedRecipe(data);
            TileUtil.actOnTile((IWorldReader)player.field_70170_p, pos, TileWorktable.class, worktable -> {
                worktable.setCurrentRecipe(recipe);
                if (player.field_71070_bA instanceof ContainerWorktable) {
                    ContainerWorktable containerWorktable = (ContainerWorktable)player.field_71070_bA;
                    containerWorktable.updateCraftMatrix();
                }
                NetworkUtil.sendNetworkPacket(new PacketWorktableRecipeUpdate((TileWorktable)worktable), pos, player.field_70170_p);
            });
        }
    }
}

