/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.recipes;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.RecipeUtils;
import forestry.worktable.inventory.CraftingInventoryForestry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class MemorizedRecipe
implements INbtWritable,
INbtReadable,
IStreamable {
    private CraftingInventoryForestry craftMatrix = new CraftingInventoryForestry();
    private List<ICraftingRecipe> recipes = new ArrayList<ICraftingRecipe>();
    private final List<String> recipeNames = new ArrayList<String>();
    private int selectedRecipe;
    private long lastUsed;
    private boolean locked;

    public MemorizedRecipe(PacketBufferForestry data) throws IOException {
        this.readData(data);
    }

    public MemorizedRecipe(CompoundNBT nbt) {
        this.read(nbt);
    }

    public MemorizedRecipe(CraftingInventoryForestry craftMatrix, List<ICraftingRecipe> recipes) {
        InventoryUtil.deepCopyInventoryContents((IInventory)craftMatrix, (IInventory)this.craftMatrix);
        this.recipes = recipes;
        for (ICraftingRecipe recipe : recipes) {
            this.recipeNames.add(recipe.func_199560_c().toString());
        }
    }

    public CraftingInventoryForestry getCraftMatrix() {
        return this.craftMatrix;
    }

    public void setCraftMatrix(CraftingInventoryForestry craftMatrix) {
        this.craftMatrix = craftMatrix;
    }

    public void incrementRecipe() {
        ++this.selectedRecipe;
        if (this.selectedRecipe >= this.recipes.size()) {
            this.selectedRecipe = 0;
        }
    }

    public void decrementRecipe() {
        --this.selectedRecipe;
        if (this.selectedRecipe < 0) {
            this.selectedRecipe = this.recipes.size() - 1;
        }
    }

    public boolean hasRecipeConflict() {
        return this.recipes.size() > 1;
    }

    public void removeRecipeConflicts(World world) {
        ICraftingRecipe recipe = this.getSelectedRecipe(world);
        this.recipes.clear();
        this.recipes.add(recipe);
        this.selectedRecipe = 0;
    }

    public ItemStack getOutputIcon(World world) {
        ItemStack recipeOutput;
        ICraftingRecipe selectedRecipe = this.getSelectedRecipe(world);
        if (selectedRecipe != null && !(recipeOutput = selectedRecipe.func_77572_b((IInventory)this.craftMatrix)).func_190926_b()) {
            return recipeOutput;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getCraftingResult(CraftingInventory inventory, World world) {
        ItemStack recipeOutput;
        ICraftingRecipe selectedRecipe = this.getSelectedRecipe(world);
        if (selectedRecipe != null && selectedRecipe.func_77569_a((IInventory)inventory, world) && !(recipeOutput = selectedRecipe.func_77572_b((IInventory)inventory)).func_190926_b()) {
            return recipeOutput;
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasRecipes() {
        return !this.recipes.isEmpty() || !this.recipeNames.isEmpty();
    }

    public boolean hasSelectedRecipe() {
        return this.hasRecipes() && this.selectedRecipe >= 0 && this.recipeNames.size() > this.selectedRecipe && this.recipeNames.get(this.selectedRecipe) != null;
    }

    public List<ICraftingRecipe> getRecipes(@Nullable World world) {
        if (this.recipes.isEmpty() && !this.recipeNames.isEmpty()) {
            for (String recipeKey : this.recipeNames) {
                ResourceLocation key = new ResourceLocation(recipeKey);
                IRecipe recipe = RecipeUtils.getRecipe(IRecipeType.field_222149_a, key, world);
                if (!(recipe instanceof ICraftingRecipe)) continue;
                this.recipes.add((ICraftingRecipe)recipe);
            }
            if (this.selectedRecipe > this.recipes.size()) {
                this.selectedRecipe = 0;
            }
        }
        return this.recipes;
    }

    @Nullable
    public ICraftingRecipe getSelectedRecipe(@Nullable World world) {
        List<ICraftingRecipe> recipes = this.getRecipes(world);
        if (recipes.isEmpty()) {
            return null;
        }
        return recipes.get(this.selectedRecipe);
    }

    public boolean hasRecipe(@Nullable ICraftingRecipe recipe, @Nullable World world) {
        return this.getRecipes(world).contains(recipe);
    }

    public void updateLastUse(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void read(CompoundNBT compoundNBT) {
        InventoryUtil.readFromNBT((IInventory)this.craftMatrix, "inventory", compoundNBT);
        this.lastUsed = compoundNBT.func_74763_f("LastUsed");
        this.locked = compoundNBT.func_74767_n("Locked");
        if (compoundNBT.func_74764_b("SelectedRecipe")) {
            this.selectedRecipe = compoundNBT.func_74762_e("SelectedRecipe");
        }
        this.recipes.clear();
        this.recipeNames.clear();
        ListNBT recipesNbt = compoundNBT.func_150295_c("Recipes", NBTUtilForestry.EnumNBTType.STRING.ordinal());
        for (int i = 0; i < recipesNbt.size(); ++i) {
            String recipeKey = recipesNbt.func_150307_f(i);
            this.recipeNames.add(recipeKey);
        }
        if (this.selectedRecipe > this.recipeNames.size()) {
            this.selectedRecipe = 0;
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT compoundNBT) {
        InventoryUtil.writeToNBT((IInventory)this.craftMatrix, "inventory", compoundNBT);
        compoundNBT.func_74772_a("LastUsed", this.lastUsed);
        compoundNBT.func_74757_a("Locked", this.locked);
        compoundNBT.func_74768_a("SelectedRecipe", this.selectedRecipe);
        ListNBT recipesNbt = new ListNBT();
        for (String recipeName : this.recipeNames) {
            recipesNbt.add((Object)StringNBT.func_229705_a_((String)recipeName));
        }
        compoundNBT.func_218657_a("Recipes", (INBT)recipesNbt);
        return compoundNBT;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeInventory((IInventory)this.craftMatrix);
        data.writeBoolean(this.locked);
        data.func_150787_b(this.selectedRecipe);
        data.func_150787_b(this.recipeNames.size());
        for (String recipeName : this.recipeNames) {
            data.func_180714_a(recipeName);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        data.readInventory((IInventory)this.craftMatrix);
        this.locked = data.readBoolean();
        this.selectedRecipe = data.func_150792_a();
        this.recipes.clear();
        this.recipeNames.clear();
        int recipeCount = data.func_150792_a();
        for (int i = 0; i < recipeCount; ++i) {
            String recipeId = data.func_218666_n();
            this.recipeNames.add(recipeId);
        }
    }
}

