/*
 * Decompiled with CFR 0.152.
 */
package genetics;

import com.google.common.base.Preconditions;
import genetics.GeneticFactory;
import genetics.alleles.AlleleHelper;
import genetics.alleles.AlleleRegistry;
import genetics.api.IGeneticApiInstance;
import genetics.api.IGeneticFactory;
import genetics.api.IGeneticSaveHandler;
import genetics.api.alleles.IAlleleHelper;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.individual.IChromosomeList;
import genetics.api.individual.IKaryotype;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IIndividualRootHelper;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.IRootComponentRegistry;
import genetics.classification.ClassificationRegistry;
import genetics.individual.ChromosomeList;
import genetics.individual.GeneticSaveHandler;
import genetics.individual.RootDefinition;
import genetics.root.IndividualRootHelper;
import genetics.root.RootComponentRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public enum ApiInstance implements IGeneticApiInstance
{
    INSTANCE;

    private static final String ERROR_MESSAGE = "A method of the genetic api was called before the api reached the state at that the value of the method is present.";
    @Nullable
    public ClassificationRegistry classificationRegistry;
    @Nullable
    public AlleleRegistry alleleRegistry;
    private final Map<String, RootDefinition> rootDefinitionByUID = new HashMap<String, RootDefinition>();
    private final Map<String, IChromosomeList> chromosomeListByUID = new HashMap<String, IChromosomeList>();

    @Override
    public ClassificationRegistry getClassificationRegistry() {
        Preconditions.checkState((this.classificationRegistry != null ? 1 : 0) != 0, (Object)ERROR_MESSAGE);
        return this.classificationRegistry;
    }

    public void setClassificationRegistry(@Nullable ClassificationRegistry classificationRegistry) {
        this.classificationRegistry = classificationRegistry;
    }

    @Override
    public IAlleleRegistry getAlleleRegistry() {
        Preconditions.checkState((this.alleleRegistry != null ? 1 : 0) != 0, (Object)ERROR_MESSAGE);
        return this.alleleRegistry;
    }

    public void setAlleleRegistry(@Nullable AlleleRegistry alleleRegistry) {
        this.alleleRegistry = alleleRegistry;
    }

    @Override
    public IAlleleHelper getAlleleHelper() {
        return AlleleHelper.INSTANCE;
    }

    @Override
    public IGeneticFactory getGeneticFactory() {
        return GeneticFactory.INSTANCE;
    }

    @Override
    public IGeneticSaveHandler getSaveHandler() {
        return GeneticSaveHandler.INSTANCE;
    }

    @Override
    public IRootComponentRegistry getComponentRegistry() {
        return RootComponentRegistry.INSTANCE;
    }

    @Override
    public IIndividualRootHelper getRootHelper() {
        return IndividualRootHelper.INSTANCE;
    }

    public <R extends IIndividualRoot> RootDefinition<R> getRoot(String rootUID) {
        Preconditions.checkNotNull((Object)rootUID, (Object)"The uid of a root definition can't be null.");
        return this.rootDefinitionByUID.computeIfAbsent(rootUID, uid -> new RootDefinition());
    }

    @Override
    public IChromosomeList getChromosomeList(String rootUID) {
        Preconditions.checkNotNull((Object)rootUID, (Object)"The uid of a root definition can't be null.");
        return this.chromosomeListByUID.computeIfAbsent(rootUID, uid -> new ChromosomeList(rootUID));
    }

    @Override
    public Optional<IKaryotype> getKaryotype(String rootUID) {
        return Optional.empty();
    }

    @Override
    public Map<String, IRootDefinition> getRoots() {
        return Collections.unmodifiableMap(this.rootDefinitionByUID);
    }

    @Override
    public boolean isModPresent() {
        return true;
    }
}

