/*
 * Decompiled with CFR 0.152.
 */
package genetics;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import genetics.ApiInstance;
import genetics.api.GeneticHelper;
import genetics.api.GeneticsAPI;
import genetics.api.IGeneTemplate;
import genetics.api.organism.IOrganism;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.DefaultStage;
import genetics.commands.CommandListAlleles;
import genetics.individual.GeneticSaveHandler;
import genetics.individual.SaveFormat;
import genetics.items.GeneTemplate;
import genetics.plugins.PluginManager;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="geneticsapi")
public class Genetics {
    public static final String MOD_ID = "geneticsapi";
    @CapabilityInject(value=IOrganism.class)
    public static Capability<IOrganism> ORGANISM;
    @CapabilityInject(value=IGeneTemplate.class)
    public static Capability<IGeneTemplate> GENE_TEMPLATE;

    public Genetics() {
        GeneticsAPI.apiInstance = ApiInstance.INSTANCE;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setupCommon);
        modBus.addListener(this::loadComplete);
        modBus.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        CapabilityManager.INSTANCE.register(IOrganism.class, new NullStorage(), () -> GeneticHelper.EMPTY);
        CapabilityManager.INSTANCE.register(IGeneTemplate.class, new NullStorage(), () -> GeneTemplate.EMPTY);
        PluginManager.create();
        PluginManager.initPlugins();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerFinished(RegistryEvent.Register<Item> event) {
        for (IRootDefinition definition : GeneticsAPI.apiInstance.getRoots().values()) {
            if (!definition.isPresent()) continue;
            definition.get().getComponentContainer().onStage(DefaultStage.REGISTRATION);
        }
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        for (IRootDefinition definition : GeneticsAPI.apiInstance.getRoots().values()) {
            if (!definition.isPresent()) continue;
            definition.get().getComponentContainer().onStage(DefaultStage.SETUP);
        }
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        for (IRootDefinition definition : GeneticsAPI.apiInstance.getRoots().values()) {
            if (!definition.isPresent()) continue;
            definition.get().getComponentContainer().onStage(DefaultStage.COMPLETION);
        }
        GeneticSaveHandler.setWriteFormat(SaveFormat.BINARY);
    }

    public void serverStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        LiteralArgumentBuilder rootCommand = LiteralArgumentBuilder.literal((String)"genetics");
        rootCommand.then(CommandListAlleles.register());
        dispatcher.register(rootCommand);
    }

    private static class NullStorage<T>
    implements Capability.IStorage<T> {
        private NullStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
        }
    }
}

