/*
 * Decompiled with CFR 0.152.
 */
package genetics.alleles;

import com.google.common.base.MoreObjects;
import genetics.api.alleles.AlleleInfo;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleType;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Allele
extends ForgeRegistryEntry<IAllele>
implements IAllele {
    protected final boolean dominant;
    private final String localisationKey;

    public Allele(boolean dominant, String localisationKey) {
        this.dominant = dominant;
        this.localisationKey = localisationKey;
    }

    @Override
    public boolean isDominant() {
        return this.dominant;
    }

    @Override
    public final String getLocalisationKey() {
        return this.localisationKey;
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getLocalisationKey());
    }

    @Override
    public IAlleleType getType() {
        return Type.INSTANCE;
    }

    public int hashCode() {
        return this.getRegistryName() != null ? this.getRegistryName().hashCode() : Objects.hash(this.dominant);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IAllele)) {
            return false;
        }
        IAllele otherAllele = (IAllele)obj;
        return this.getRegistryName() != null ? this.getRegistryName().equals((Object)((IAllele)obj).getRegistryName()) : this.dominant == otherAllele.isDominant();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getRegistryName()).add("dominant", this.dominant).toString();
    }

    public static class Type
    implements IAlleleType {
        public static final Type INSTANCE = new Type();

        @Override
        public IAllele deserialize(AlleleInfo info) {
            return new Allele(info.dominant, info.name);
        }
    }
}

