/*
 * Decompiled with CFR 0.152.
 */
package genetics.alleles;

import com.google.common.collect.HashMultimap;
import genetics.alleles.AlleleHelper;
import genetics.api.alleles.Allele;
import genetics.api.alleles.AlleleCategorizedValue;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleData;
import genetics.api.alleles.IAlleleHandler;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.alleles.IAlleleValue;
import genetics.api.classification.IClassification;
import genetics.api.individual.IChromosomeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class AlleleRegistry
implements IAlleleRegistry {
    private static final int ALLELE_ARRAY_SIZE = 2048;
    private final ForgeRegistry<IAllele> registry;
    private final HashMultimap<IChromosomeType, IAllele> allelesByType = HashMultimap.create();
    private final HashMultimap<IAllele, IChromosomeType> typesByAllele = HashMultimap.create();
    private final ResourceLocation DEFAULT_NAME = new ResourceLocation("geneticsapi", "default");
    private final IAllele defaultAllele = (IAllele)new Allele("default", false).setRegistryName(this.DEFAULT_NAME);
    private final Set<IAlleleHandler> handlers = new HashSet<IAlleleHandler>();
    private final ArrayList<ResourceLocation> blacklist = new ArrayList();

    public AlleleRegistry() {
        RegistryBuilder builder = new RegistryBuilder().setMaxID(2048).setName(new ResourceLocation("geneticsapi", "alleles")).setDefaultKey(this.DEFAULT_NAME).setType(IAllele.class);
        this.registry = (ForgeRegistry)builder.create();
        this.registerHandler(AlleleHelper.INSTANCE);
    }

    @Override
    public <A extends IAllele> A registerAllele(A allele, IChromosomeType ... types) {
        this.addValidAlleleTypes(allele, types);
        if (!this.registry.containsKey(allele.getRegistryName())) {
            this.registry.register(allele);
            this.handlers.forEach(h -> h.onRegisterAllele(allele));
        }
        if (allele instanceof IAlleleSpecies) {
            IClassification branch = ((IAlleleSpecies)allele).getBranch();
            branch.addMemberSpecies((IAlleleSpecies)allele);
        }
        return allele;
    }

    @Override
    public IAlleleRegistry addValidAlleleTypes(ResourceLocation registryName, IChromosomeType ... types) {
        Optional<IAllele> alleleOptional = this.getAllele(registryName);
        alleleOptional.ifPresent(allele -> this.addValidAlleleTypes((IAllele)allele, types));
        return this;
    }

    @Override
    public <V> IAlleleValue<V> registerAllele(String category, String valueName, V value, boolean dominant, IChromosomeType ... types) {
        return this.registerAllele(new AlleleCategorizedValue<V>(ModLoadingContext.get().getActiveContainer().getModId(), category, valueName, value, dominant), types);
    }

    @Override
    public <V> IAlleleValue<V> registerAllele(IAlleleData<V> value, IChromosomeType ... types) {
        IAlleleValue alleleValue = this.registerAllele(value.createAllele(), types);
        this.handlers.forEach(handler -> handler.onRegisterData(alleleValue, value));
        return alleleValue;
    }

    @Override
    public <V> IAlleleValue<V>[] registerAlleles(IAlleleData<V>[] values, IChromosomeType ... types) {
        IAlleleValue[] alleles = new IAlleleValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            alleles[i] = this.registerAllele(values[i], types);
        }
        return alleles;
    }

    @Override
    public IAlleleRegistry addValidAlleleTypes(IAllele allele, IChromosomeType ... types) {
        this.handlers.forEach(h -> h.onAddTypes(allele, types));
        for (IChromosomeType chromosomeType : types) {
            if (!this.isValidAllele(allele, chromosomeType)) {
                throw new IllegalArgumentException("Allele (" + allele + ") is not a valid allele for the chromosome type (" + chromosomeType + ").");
            }
            this.allelesByType.put((Object)chromosomeType, (Object)allele);
            this.typesByAllele.put((Object)allele, (Object)chromosomeType);
        }
        return this;
    }

    @Override
    public IAllele getDefaultAllele() {
        return this.defaultAllele;
    }

    @Override
    public ResourceLocation getDefaultKey() {
        return this.DEFAULT_NAME;
    }

    @Override
    public Collection<IChromosomeType> getChromosomeTypes(IAllele allele) {
        return this.typesByAllele.get((Object)allele);
    }

    @Override
    public Collection<IAllele> getRegisteredAlleles(IChromosomeType type) {
        return this.allelesByType.get((Object)type);
    }

    @Override
    public Collection<IAllele> getRegisteredAlleles() {
        return this.registry.getValues();
    }

    @Override
    public Collection<ResourceLocation> getRegisteredNames() {
        return this.registry.getKeys();
    }

    @Override
    public Optional<IAllele> getAllele(ResourceLocation location) {
        return Optional.ofNullable(this.registry.getValue(location));
    }

    @Override
    public boolean isValidAllele(IAllele allele, IChromosomeType type) {
        return type.isValid(allele);
    }

    @Override
    public void registerHandler(IAlleleHandler handler) {
        this.handlers.add(handler);
    }

    public Set<IAlleleHandler> getHandlers() {
        return this.handlers;
    }

    public int getId(IAllele allele) {
        return this.registry.getID((IForgeRegistryEntry)allele);
    }

    public int getId(ResourceLocation alleleName) {
        return this.registry.getID(alleleName);
    }

    @Nullable
    public IAllele getAllele(int id) {
        return (IAllele)this.registry.getValue(id);
    }

    @Override
    public void blacklistAllele(ResourceLocation registryName) {
        this.blacklist.add(registryName);
    }

    @Override
    public Collection<ResourceLocation> getAlleleBlacklist() {
        return Collections.unmodifiableCollection(this.blacklist);
    }

    @Override
    public boolean isBlacklisted(ResourceLocation registryName) {
        return this.blacklist.contains(registryName);
    }
}

