/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.alleles;

import com.google.common.base.MoreObjects;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleType;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Allele
extends ForgeRegistryEntry<IAllele>
implements IAllele {
    public static final IAllele EMPTY = (IAllele)new Allele("empty", false).setRegistryName(new ResourceLocation("genetics", "empty"));
    protected final boolean dominant;
    protected final String localisationKey;

    public Allele(String localisationKey, boolean dominant) {
        this.localisationKey = localisationKey;
        this.dominant = dominant;
    }

    @Override
    public boolean isDominant() {
        return this.dominant;
    }

    public int hashCode() {
        return this.getRegistryName() != null ? this.getRegistryName().hashCode() : Objects.hash(this.dominant);
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getLocalisationKey());
    }

    @Override
    public String getLocalisationKey() {
        return this.localisationKey;
    }

    @Override
    public IAlleleType getType() {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IAllele)) {
            return false;
        }
        IAllele otherAllele = (IAllele)obj;
        return this.getRegistryName() != null ? this.getRegistryName().equals((Object)((IAllele)obj).getRegistryName()) : this.dominant == otherAllele.isDominant();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getRegistryName()).add("dominant", this.dominant).add("key", (Object)this.localisationKey).toString();
    }
}

