/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.events;

import genetics.api.individual.IIndividual;
import genetics.api.root.IGeneticListener;
import genetics.api.root.IIndividualRootBuilder;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.IRootComponent;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IGenericEvent;

public class RootBuilderEvents<I extends IIndividual>
extends Event {
    private final IIndividualRootBuilder<I> root;
    private final IRootDefinition definition;

    private RootBuilderEvents(IIndividualRootBuilder<I> root) {
        this.root = root;
        this.definition = root.getDefinition();
    }

    public boolean isRoot(IRootDefinition rootDefinition) {
        return this.definition == rootDefinition;
    }

    public IIndividualRootBuilder<I> getRoot() {
        return this.root;
    }

    public static class CreateComponent<I extends IIndividual, C extends IRootComponent>
    extends RootBuilderEvents<I>
    implements IGenericEvent<C> {
        private final ComponentKey<?> key;
        private final C component;

        public CreateComponent(IIndividualRootBuilder<I> root, ComponentKey<?> key, C component) {
            super(root);
            this.key = key;
            this.component = component;
        }

        public C getComponent() {
            return this.component;
        }

        public ComponentKey getKey() {
            return this.key;
        }

        public Type getGenericType() {
            return this.key.getComponentClass();
        }
    }

    public static class GatherListeners<I extends IIndividual>
    extends Event {
        private final List<IGeneticListener<I>> listeners = new LinkedList<IGeneticListener<I>>();
        private final IRootDefinition definition;
        private final String uid;

        public GatherListeners(IRootDefinition definition, String uid) {
            this.definition = definition;
            this.uid = uid;
        }

        public IRootDefinition getDefinition() {
            return this.definition;
        }

        public String getUID() {
            return this.uid;
        }

        public void add(IGeneticListener<I> listener) {
            this.listeners.add(listener);
        }

        @SafeVarargs
        public final void add(IGeneticListener<I> ... listeners) {
            this.add(Arrays.asList(listeners));
        }

        public void add(Collection<IGeneticListener<I>> listeners) {
            this.listeners.addAll(listeners);
        }

        public List<IGeneticListener<I>> getListeners() {
            return Collections.unmodifiableList(this.listeners);
        }
    }
}

