/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.root;

import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import genetics.api.individual.IGenomeWrapper;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.organism.IOrganismType;
import genetics.api.organism.IOrganismTypes;
import genetics.api.root.IDisplayHelper;
import genetics.api.root.IRootDefinition;
import genetics.api.root.ITemplateContainer;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.IRootComponent;
import genetics.api.root.components.IRootComponentContainer;
import genetics.api.root.translator.IIndividualTranslator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IIndividualRoot<I extends IIndividual> {
    public I create(CompoundNBT var1);

    public I create(IGenome var1);

    public I create(IGenome var1, IGenome var2);

    default public Optional<I> create(ItemStack stack) {
        return this.getTypes().createIndividual(stack);
    }

    default public ItemStack createStack(I individual, IOrganismType type) {
        return this.getTypes().createStack(individual, type);
    }

    default public Optional<IOrganismType> getType(ItemStack itemStack) {
        return this.getTypes().getType(itemStack);
    }

    default public IAllele[] getTemplate(String identifier) {
        return this.getTemplates().getTemplate(identifier);
    }

    public Class<? extends I> getMemberClass();

    public Optional<I> create(String var1);

    default public I templateAsIndividual(IAllele[] template) {
        return this.templateAsIndividual(template, null);
    }

    default public I templateAsIndividual(IAllele[] templateActive, @Nullable IAllele[] templateInactive) {
        IGenome genome = this.getKaryotype().templateAsGenome(templateActive, templateInactive);
        return this.create(genome);
    }

    public I getDefaultMember();

    public ItemStack createStack(IAllele var1, IOrganismType var2);

    public boolean isMember(ItemStack var1);

    public IGenomeWrapper createWrapper(IGenome var1);

    public List<I> getIndividualTemplates();

    public ITemplateContainer<I> getTemplates();

    public IKaryotype getKaryotype();

    public IIndividualTranslator<I> getTranslator();

    default public Optional<I> translateMember(BlockState objectToTranslate) {
        return this.getTranslator().translateMember(objectToTranslate);
    }

    default public Optional<I> translateMember(ItemStack objectToTranslate) {
        return this.getTranslator().translateMember(objectToTranslate);
    }

    default public ItemStack getGeneticEquivalent(BlockState objectToTranslate) {
        return this.getTranslator().getGeneticEquivalent(objectToTranslate);
    }

    default public ItemStack getGeneticEquivalent(ItemStack objectToTranslate) {
        return this.getTranslator().getGeneticEquivalent(objectToTranslate);
    }

    public IOrganismTypes<I> getTypes();

    public String getUID();

    public boolean hasComponent(ComponentKey<?> var1);

    public <C extends IRootComponent<I>> Optional<C> getComponentSafe(ComponentKey<?> var1);

    public <C extends IRootComponent<I>> C getComponent(ComponentKey<?> var1);

    public IRootComponentContainer<I> getComponentContainer();

    public IDisplayHelper<I> getDisplayHelper();

    public IRootDefinition<? extends IIndividualRoot<I>> getDefinition();

    public <T extends IIndividualRoot<?>> T cast();
}

