/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.root;

import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IIndividualRootFactory;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.IRootComponent;
import genetics.api.root.components.IRootComponentFactory;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface IIndividualRootBuilder<I extends IIndividual> {
    public IIndividualRootBuilder<I> addChromosome(IChromosomeType var1);

    public IIndividualRootBuilder<I> addChromosome(IChromosomeType ... var1);

    public IIndividualRootBuilder<I> setSpeciesType(IChromosomeType var1);

    public IIndividualRootBuilder<I> setTemplateFactory(BiFunction<IKaryotype, IAllele[], IAlleleTemplateBuilder> var1);

    public IIndividualRootBuilder<I> setRootFactory(IIndividualRootFactory<I, IIndividualRoot<I>> var1);

    public IIndividualRootBuilder<I> setRootFactory(Class<? extends I> var1);

    public IIndividualRootBuilder<I> setDefaultTemplate(Function<IAlleleTemplateBuilder, IAlleleTemplate> var1);

    public <R extends IIndividualRoot<I>> IRootDefinition<R> getDefinition();

    public IIndividualRootBuilder<I> addComponent(ComponentKey var1);

    public <C extends IRootComponent<I>> IIndividualRootBuilder<I> addComponent(ComponentKey var1, IRootComponentFactory<I, C> var2);

    public <C extends IRootComponent<I>> IIndividualRootBuilder<I> addListener(ComponentKey var1, Consumer<C> var2);
}

