/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.root;

import com.google.common.collect.ImmutableList;
import genetics.api.GeneticsAPI;
import genetics.api.IGeneticFactory;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.organism.IOrganismType;
import genetics.api.organism.IOrganismTypes;
import genetics.api.root.IDisplayHelper;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootContext;
import genetics.api.root.IRootDefinition;
import genetics.api.root.ITemplateContainer;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.components.IRootComponent;
import genetics.api.root.components.IRootComponentContainer;
import genetics.api.root.translator.IIndividualTranslator;
import genetics.individual.RootDefinition;
import genetics.root.RootComponentContainer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public abstract class IndividualRoot<I extends IIndividual>
implements IIndividualRoot<I> {
    protected final IRootDefinition<? extends IIndividualRoot<I>> definition;
    protected final IOrganismTypes<I> types;
    protected final ITemplateContainer<I> templates;
    protected final IKaryotype karyotype;
    protected final String uid;
    private ImmutableList<I> individualTemplates;
    private I defaultMember;
    private final IRootComponentContainer<I> components;
    @Nullable
    private IDisplayHelper<I> displayHelper;

    public IndividualRoot(IRootContext<I> context) {
        this.uid = context.getKaryotype().getUID();
        this.definition = context.getDefinition();
        ((RootDefinition)this.definition).setRoot(this);
        this.karyotype = context.getKaryotype();
        this.components = new RootComponentContainer<I>(context.createComponents(this), context.getComponentListeners(), context.getListeners());
        this.types = (IOrganismTypes)this.components.get(ComponentKeys.TYPES);
        this.templates = (ITemplateContainer)this.components.get(ComponentKeys.TEMPLATES);
        this.createDefault();
    }

    protected void createDefault() {
        this.defaultMember = this.create(this.karyotype.getDefaultGenome());
        ImmutableList.Builder templateBuilder = new ImmutableList.Builder();
        for (IAllele[] template : this.templates.getTemplates()) {
            templateBuilder.add(this.templateAsIndividual(template));
        }
        this.individualTemplates = templateBuilder.build();
    }

    @Override
    public final String getUID() {
        return this.uid;
    }

    @Override
    public I getDefaultMember() {
        return this.defaultMember;
    }

    @Override
    public List<I> getIndividualTemplates() {
        return this.individualTemplates;
    }

    @Override
    public Optional<I> create(String templateIdentifier) {
        IAllele[] template = this.templates.getTemplate(templateIdentifier);
        if (template.length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.create(this.karyotype.templateAsGenome(template)));
    }

    @Override
    public ItemStack createStack(IAllele allele, IOrganismType type) {
        Optional<I> optional = this.create(allele.getRegistryName().toString());
        return optional.map(i -> this.types.createStack((IIndividual)i, type)).orElse(ItemStack.field_190927_a);
    }

    @Override
    public boolean isMember(ItemStack stack) {
        return this.types.getType(stack).isPresent();
    }

    @Override
    public ITemplateContainer<I> getTemplates() {
        return this.templates;
    }

    @Override
    public IKaryotype getKaryotype() {
        return this.karyotype;
    }

    @Override
    public IIndividualTranslator<I> getTranslator() {
        Optional translator = this.getComponentSafe(ComponentKeys.TRANSLATORS);
        if (!translator.isPresent()) {
            throw new IllegalStateException(String.format("No translator component was added to the root with the uid '%s'.", this.getUID()));
        }
        return (IIndividualTranslator)translator.get();
    }

    @Override
    public IOrganismTypes<I> getTypes() {
        return this.types;
    }

    @Override
    public IRootDefinition<? extends IIndividualRoot<I>> getDefinition() {
        return this.definition;
    }

    @Override
    public <T extends IIndividualRoot<?>> T cast() {
        return (T)this;
    }

    @Override
    public boolean hasComponent(ComponentKey<?> key) {
        return this.components.has(key);
    }

    @Override
    public <C extends IRootComponent<I>> Optional<C> getComponentSafe(ComponentKey<?> key) {
        return this.components.getSafe(key);
    }

    @Override
    public <C extends IRootComponent<I>> C getComponent(ComponentKey<?> key) {
        return this.components.get(key);
    }

    @Override
    public IRootComponentContainer<I> getComponentContainer() {
        return this.components;
    }

    @Override
    public IDisplayHelper<I> getDisplayHelper() {
        if (this.displayHelper == null) {
            IGeneticFactory geneticFactory = GeneticsAPI.apiInstance.getGeneticFactory();
            this.displayHelper = geneticFactory.createDisplayHelper(this);
        }
        return this.displayHelper;
    }
}

