/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.root.components;

import genetics.api.root.components.DefaultStage;
import genetics.api.root.components.IRootComponent;
import genetics.api.root.components.IStage;

public class ComponentKey<C extends IRootComponent> {
    private final String name;
    private final Class<C> componentClass;
    private final IStage stage;

    public static <C extends IRootComponent> ComponentKey<C> create(String name, Class<C> componentClass) {
        return ComponentKey.create(name, componentClass, DefaultStage.CREATION);
    }

    public static <C extends IRootComponent> ComponentKey<C> create(String name, Class<C> componentClass, IStage stage) {
        return new ComponentKey<C>(name, componentClass, stage);
    }

    private ComponentKey(String name, Class<C> componentClass, IStage stage) {
        this.name = name;
        this.componentClass = componentClass;
        this.stage = stage;
    }

    public <R> R cast(C instance) {
        return (R)instance;
    }

    public Class<C> getComponentClass() {
        return this.componentClass;
    }

    public String getName() {
        return this.name;
    }

    public IStage getStage() {
        return this.stage;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o == this || o != null && o.toString().equals(this.name);
    }
}

