/*
 * Decompiled with CFR 0.152.
 */
package genetics.classification;

import genetics.ApiInstance;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.classification.IClassification;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;

public class Classification
implements IClassification {
    private final IClassification.EnumClassLevel level;
    private final String uid;
    private final String scientific;
    @Nullable
    private IClassification parent;
    private final ArrayList<IAlleleSpecies> members = new ArrayList();
    private final ArrayList<IClassification> groups = new ArrayList();

    public Classification(IClassification.EnumClassLevel level, String uid, String scientific) {
        this.level = level;
        this.uid = level.name().toLowerCase(Locale.ENGLISH) + "." + uid;
        this.scientific = scientific;
        ApiInstance.INSTANCE.getClassificationRegistry().registerClassification(this);
    }

    @Override
    public IClassification.EnumClassLevel getLevel() {
        return this.level;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    @Nullable
    public IClassification getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IClassification parent) {
        this.parent = parent;
    }

    @Override
    public String getScientific() {
        return this.scientific;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)("genetics." + this.uid), (Object[])new Object[0]);
    }

    @Override
    public String getDescription() {
        return I18n.func_135052_a((String)("genetics." + this.uid + ".description"), (Object[])new Object[0]);
    }

    @Override
    public IClassification[] getMemberGroups() {
        return this.groups.toArray(new IClassification[this.groups.size()]);
    }

    @Override
    public void addMemberGroup(IClassification group) {
        this.groups.add(group);
        group.setParent(this);
    }

    @Override
    public IAlleleSpecies[] getMemberSpecies() {
        return this.members.toArray(new IAlleleSpecies[0]);
    }

    @Override
    public void addMemberSpecies(IAlleleSpecies species) {
        this.members.add(species);
    }
}

