/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import genetics.api.GeneticsAPI;
import genetics.api.individual.IChromosomeList;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IChromosomeTypeBuilder;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import genetics.individual.ChromosomeTypeBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ChromosomeList
implements IChromosomeList {
    private final String rootUID;
    private final IRootDefinition definition;
    private final List<IChromosomeType> types = new LinkedList<IChromosomeType>();

    public ChromosomeList(String rootUID) {
        this.rootUID = rootUID;
        this.definition = GeneticsAPI.apiInstance.getRoot(rootUID);
    }

    @Override
    public IChromosomeTypeBuilder builder() {
        return new ChromosomeTypeBuilder(this);
    }

    @Override
    public Collection<IChromosomeType> types() {
        return this.types;
    }

    @Override
    public IChromosomeType[] typesArray() {
        return this.types.toArray(new IChromosomeType[0]);
    }

    @Override
    public int size() {
        return this.types.size();
    }

    @Override
    public String getUID() {
        return this.rootUID;
    }

    public <T extends IChromosomeType> T add(T type) {
        this.types.add(type);
        return type;
    }

    @Override
    public Iterator<IChromosomeType> iterator() {
        return this.types.iterator();
    }

    @Override
    public IIndividualRoot getRoot() {
        return this.definition.get();
    }

    @Override
    public IRootDefinition getDefinition() {
        return this.definition;
    }
}

