/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import com.google.common.base.Preconditions;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeAllele;
import genetics.api.individual.IChromosomeList;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IChromosomeTypeBuilder;
import genetics.api.individual.IChromosomeValue;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import genetics.individual.ChromosomeList;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ChromosomeTypeBuilder
implements IChromosomeTypeBuilder {
    private final ChromosomeList list;
    @Nullable
    private String name;

    public ChromosomeTypeBuilder(ChromosomeList list) {
        this.list = list;
    }

    @Override
    public IChromosomeTypeBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public <V> IChromosomeValue<V> asValue(Class<? extends V> valueClass) {
        Preconditions.checkNotNull((Object)this.name, (Object)"A chromosome type must have a name that is not null");
        return this.list.add(new Value<V>(this.list.size(), this.name, this.list, valueClass));
    }

    @Override
    public <A extends IAllele> IChromosomeAllele<A> asAllele(Class<? extends A> alleleClass) {
        Preconditions.checkNotNull((Object)this.name, (Object)"A chromosome type must have a name that is not null");
        return this.list.add(new Allele<A>(this.list.size(), this.name, this.list, alleleClass));
    }

    private static class Value<V>
    extends Type
    implements IChromosomeValue<V> {
        private final Class<? extends V> valueClass;

        public Value(int index, String name, IChromosomeList list, Class<? extends V> valueClass) {
            super(index, name, list);
            this.valueClass = valueClass;
        }

        @Override
        public Class<? extends V> getValueClass() {
            return this.valueClass;
        }

        @Override
        public boolean isValid(IAllele allele) {
            if (!(allele instanceof IAlleleValue)) {
                return false;
            }
            IAlleleValue alleleValue = (IAlleleValue)allele;
            return this.valueClass.isInstance(alleleValue.getValue());
        }
    }

    private static class Allele<A extends IAllele>
    extends Type
    implements IChromosomeAllele<A> {
        private final Class<? extends A> alleleClass;

        public Allele(int index, String name, IChromosomeList list, Class<? extends A> alleleClass) {
            super(index, name, list);
            this.alleleClass = alleleClass;
        }

        @Override
        public Class<? extends A> getAlleleClass() {
            return this.alleleClass;
        }

        @Override
        public A castAllele(IAllele allele) {
            return (A)((IAllele)this.alleleClass.cast(allele));
        }

        @Override
        public boolean isValid(IAllele allele) {
            return this.alleleClass.isInstance(allele);
        }
    }

    private static abstract class Type
    implements IChromosomeType {
        private final int index;
        private final String name;
        private final IChromosomeList list;

        public Type(int index, String name, IChromosomeList list) {
            this.index = index;
            this.name = name;
            this.list = list;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ITextComponent getDisplayName() {
            return new TranslationTextComponent("for.gui." + this.name);
        }

        @Override
        public IIndividualRoot getRoot() {
            return this.list.getRoot();
        }

        @Override
        public IRootDefinition getDefinition() {
            return this.list.getDefinition();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

