/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IIndividualBuilder;
import genetics.api.individual.IKaryotype;
import genetics.api.root.IIndividualRoot;
import net.minecraft.util.ResourceLocation;

public final class IndividualBuilder<I extends IIndividual>
implements IIndividualBuilder<I> {
    private final IIndividualRoot<I> root;
    private final IAlleleTemplateBuilder activeBuilder;
    private final IAlleleTemplateBuilder inactiveBuilder;
    private final I creationIndividual;

    public IndividualBuilder(I individual) {
        this.root = individual.getRoot();
        IGenome genome = individual.getGenome();
        IKaryotype karyotype = this.root.getKaryotype();
        this.activeBuilder = karyotype.createTemplate(genome.getActiveAlleles());
        this.inactiveBuilder = karyotype.createTemplate(genome.getInactiveAlleles());
        this.creationIndividual = individual;
    }

    @Override
    public IIndividualBuilder<I> set(IChromosomeType type, IAllele allele, boolean active) {
        IAlleleTemplateBuilder builder = active ? this.activeBuilder : this.inactiveBuilder;
        builder.set(type, allele);
        return this;
    }

    @Override
    public IIndividualBuilder<I> set(IChromosomeType type, ResourceLocation registryName, boolean active) {
        IAlleleTemplateBuilder builder = active ? this.activeBuilder : this.inactiveBuilder;
        builder.set(type, registryName);
        return this;
    }

    @Override
    public IIndividualRoot<I> getRoot() {
        return this.root;
    }

    @Override
    public I getCreationIndividual() {
        return this.creationIndividual;
    }

    @Override
    public I build() {
        IAlleleTemplate activeTemplate = this.activeBuilder.build();
        IAlleleTemplate inactiveTemplate = this.inactiveBuilder.build();
        I individual = this.root.create(activeTemplate.toGenome(inactiveTemplate));
        individual.onBuild((IIndividual)this.creationIndividual);
        return individual;
    }
}

