/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class RootDefinition<R extends IIndividualRoot>
implements IRootDefinition<R> {
    @Nullable
    private R root = null;

    public void setRoot(@Nullable R definition) {
        this.root = definition;
    }

    @Override
    public Optional<R> maybe() {
        return Optional.ofNullable(this.root);
    }

    @Override
    public R get() {
        if (this.root == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.root;
    }

    @Override
    public <T extends IIndividualRoot> T cast() {
        return (T)this.get();
    }

    @Override
    public R orElse(R other) {
        return this.root != null ? this.root : other;
    }

    @Override
    public boolean test(Predicate<? super R> predicate) {
        Objects.requireNonNull(predicate);
        return this.root != null && predicate.test(this.root);
    }

    @Override
    public Optional<R> filter(Predicate<? super R> predicate) {
        Objects.requireNonNull(predicate);
        if (this.root == null) {
            return Optional.empty();
        }
        return predicate.test(this.root) ? Optional.of(this.root) : Optional.empty();
    }

    @Override
    public boolean isPresent() {
        return this.root != null;
    }

    @Override
    public void ifPresent(Consumer<R> consumer) {
        if (this.root != null) {
            consumer.accept(this.root);
        }
    }

    @Override
    public <U> Optional<U> map(Function<? super R, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.root));
    }
}

