/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import genetics.api.alleles.IAllele;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IKaryotype;
import genetics.individual.Chromosome;
import genetics.individual.ChromosomeInfo;
import genetics.utils.SimpleByteBuf;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public enum SaveFormat {
    UID{

        @Override
        public CompoundNBT writeTag(IChromosome[] chromosomes, IKaryotype karyotype, CompoundNBT tagCompound) {
            ListNBT tagList = new ListNBT();
            for (int i = 0; i < chromosomes.length; ++i) {
                if (chromosomes[i] == null) continue;
                CompoundNBT chromosomeTag = new CompoundNBT();
                chromosomeTag.func_74774_a(SaveFormat.SLOT_TAG, (byte)i);
                chromosomes[i].writeToNBT(chromosomeTag);
                tagList.add((Object)chromosomeTag);
            }
            tagCompound.func_218657_a(SaveFormat.CHROMOSOMES_TAG, (INBT)tagList);
            return tagCompound;
        }

        @Override
        IChromosome[] readTag(IKaryotype karyotype, CompoundNBT tagCompound) {
            IChromosomeType[] geneTypes = karyotype.getChromosomeTypes();
            ListNBT chromosomesNBT = tagCompound.func_150295_c(SaveFormat.CHROMOSOMES_TAG, 10);
            IChromosome[] chromosomes = new IChromosome[geneTypes.length];
            ResourceLocation primaryTemplateIdentifier = null;
            ResourceLocation secondaryTemplateIdentifier = null;
            for (int i = 0; i < chromosomesNBT.size(); ++i) {
                CompoundNBT chromosomeNBT = chromosomesNBT.func_150305_b(i);
                byte chromosomeOrdinal = chromosomeNBT.func_74771_c(SaveFormat.SLOT_TAG);
                if (chromosomeOrdinal < 0 || chromosomeOrdinal >= chromosomes.length) continue;
                IChromosomeType geneType = geneTypes[chromosomeOrdinal];
                Chromosome chromosome = Chromosome.create(primaryTemplateIdentifier, secondaryTemplateIdentifier, geneType, chromosomeNBT);
                chromosomes[chromosomeOrdinal] = chromosome;
                if (!geneType.equals(karyotype.getSpeciesType())) continue;
                primaryTemplateIdentifier = chromosome.getActiveAllele().getRegistryName();
                secondaryTemplateIdentifier = chromosome.getInactiveAllele().getRegistryName();
            }
            return chromosomes;
        }

        @Override
        @Nullable
        IAllele getAlleleDirectly(CompoundNBT genomeNBT, IChromosomeType geneType, boolean active) {
            ListNBT tagList = genomeNBT.func_150295_c(SaveFormat.CHROMOSOMES_TAG, 10);
            if (tagList.isEmpty()) {
                return null;
            }
            CompoundNBT chromosomeTag = tagList.func_150305_b(geneType.getIndex());
            if (chromosomeTag.isEmpty()) {
                return null;
            }
            return (active ? Chromosome.getActiveAllele(chromosomeTag) : Chromosome.getInactiveAllele(chromosomeTag)).orElse(null);
        }

        @Override
        public IChromosome getSpecificChromosome(CompoundNBT genomeNBT, IChromosomeType chromosomeType) {
            IChromosome[] chromosomes = this.readTag(chromosomeType.getRoot().getKaryotype(), genomeNBT);
            return chromosomes[chromosomeType.getIndex()];
        }

        @Override
        public boolean canLoad(CompoundNBT tagCompound) {
            return tagCompound.func_74764_b(SaveFormat.CHROMOSOMES_TAG) && tagCompound.func_74764_b(SaveFormat.VERSION_TAG);
        }
    }
    ,
    UUID_DEPRECATED{

        @Override
        public CompoundNBT writeTag(IChromosome[] chromosomes, IKaryotype karyotype, CompoundNBT tagCompound) {
            throw new UnsupportedOperationException();
        }

        @Override
        IChromosome[] readTag(IKaryotype karyotype, CompoundNBT tagCompound) {
            IChromosomeType[] geneTypes = karyotype.getChromosomeTypes();
            ListNBT chromosomesNBT = tagCompound.func_150295_c(SaveFormat.CHROMOSOMES_TAG, 10);
            IChromosome[] chromosomes = new IChromosome[geneTypes.length];
            ResourceLocation primaryTemplateIdentifier = null;
            ResourceLocation secondaryTemplateIdentifier = null;
            for (int i = 0; i < chromosomesNBT.size(); ++i) {
                CompoundNBT chromosomeNBT = chromosomesNBT.func_150305_b(i);
                byte chromosomeOrdinal = chromosomeNBT.func_74771_c(SaveFormat.SLOT_TAG);
                if (chromosomeOrdinal < 0 || chromosomeOrdinal >= chromosomes.length) continue;
                IChromosomeType geneType = geneTypes[chromosomeOrdinal];
                Chromosome chromosome = Chromosome.create(primaryTemplateIdentifier, secondaryTemplateIdentifier, geneType, chromosomeNBT);
                chromosomes[chromosomeOrdinal] = chromosome;
                if (geneType != karyotype.getSpeciesType()) continue;
                primaryTemplateIdentifier = chromosome.getActiveAllele().getRegistryName();
                secondaryTemplateIdentifier = chromosome.getInactiveAllele().getRegistryName();
            }
            return chromosomes;
        }

        @Override
        @Nullable
        IAllele getAlleleDirectly(CompoundNBT genomeNBT, IChromosomeType geneType, boolean active) {
            ListNBT tagList = genomeNBT.func_150295_c(SaveFormat.CHROMOSOMES_TAG, 10);
            if (tagList.isEmpty()) {
                return null;
            }
            CompoundNBT chromosomeTag = tagList.func_150305_b(geneType.getIndex());
            if (chromosomeTag.isEmpty()) {
                return null;
            }
            Chromosome chromosome = Chromosome.create(null, null, geneType, chromosomeTag);
            return active ? chromosome.getActiveAllele() : chromosome.getInactiveAllele();
        }

        @Override
        public IChromosome getSpecificChromosome(CompoundNBT genomeNBT, IChromosomeType geneType) {
            IChromosome[] chromosomes = this.readTag(geneType.getRoot().getKaryotype(), genomeNBT);
            return chromosomes[geneType.getIndex()];
        }

        @Override
        public boolean canLoad(CompoundNBT tagCompound) {
            return tagCompound.func_74764_b(SaveFormat.CHROMOSOMES_TAG);
        }
    }
    ,
    BINARY{
        private static final String DATA_TAG = "data";

        @Override
        CompoundNBT writeTag(IChromosome[] chromosomes, IKaryotype karyotype, CompoundNBT tagCompound) {
            SimpleByteBuf byteBuf = new SimpleByteBuf(chromosomes.length);
            byteBuf.writeChromosomes(chromosomes, karyotype);
            tagCompound.func_74773_a(DATA_TAG, byteBuf.toByteArray());
            tagCompound.func_74768_a(SaveFormat.VERSION_TAG, 1);
            return tagCompound;
        }

        @Override
        IChromosome[] readTag(IKaryotype karyotype, CompoundNBT tagCompound) {
            byte[] data = tagCompound.func_74770_j(DATA_TAG);
            SimpleByteBuf simpleByteBuf = new SimpleByteBuf(data);
            return simpleByteBuf.readChromosomes(karyotype);
        }

        @Override
        @Nullable
        IAllele getAlleleDirectly(CompoundNBT genomeNBT, IChromosomeType geneType, boolean active) {
            byte[] data = genomeNBT.func_74770_j(DATA_TAG);
            SimpleByteBuf simpleByteBuf = new SimpleByteBuf(data);
            ChromosomeInfo chromosomeInfo = simpleByteBuf.readChromosome(geneType);
            IChromosome chromosome = chromosomeInfo.chromosome;
            if (chromosome == null) {
                return null;
            }
            return active ? chromosome.getActiveAllele() : chromosome.getInactiveAllele();
        }

        @Override
        public IChromosome getSpecificChromosome(CompoundNBT genomeNBT, IChromosomeType geneType) {
            byte[] data = genomeNBT.func_74770_j(DATA_TAG);
            SimpleByteBuf simpleByteBuf = new SimpleByteBuf(data);
            ChromosomeInfo chromosomeInfo = simpleByteBuf.readChromosome(geneType);
            if (chromosomeInfo.chromosome == null) {
                return this.fixData(genomeNBT, chromosomeInfo);
            }
            return chromosomeInfo.chromosome;
        }

        private IChromosome fixData(CompoundNBT genomeNBT, ChromosomeInfo missingChromosome) {
            IChromosomeType geneType = missingChromosome.chromosomeType;
            IKaryotype karyotype = geneType.getRoot().getKaryotype();
            IChromosome[] chromosomes = this.readTag(karyotype, genomeNBT);
            Chromosome chromosome = Chromosome.create(missingChromosome.activeSpeciesUid, missingChromosome.inactiveSpeciesUid, geneType, null, null);
            chromosomes[geneType.getIndex()] = chromosome;
            this.writeTag(chromosomes, karyotype, genomeNBT);
            return chromosome;
        }

        @Override
        public boolean canLoad(CompoundNBT tagCompound) {
            return tagCompound.func_74764_b(DATA_TAG);
        }
    };

    private static final String VERSION_TAG = "version";
    private static final String SLOT_TAG = "Slot";
    private static final int VERSION = 1;
    private static final String CHROMOSOMES_TAG = "Chromosomes";

    abstract CompoundNBT writeTag(IChromosome[] var1, IKaryotype var2, CompoundNBT var3);

    abstract IChromosome[] readTag(IKaryotype var1, CompoundNBT var2);

    @Nullable
    abstract IAllele getAlleleDirectly(CompoundNBT var1, IChromosomeType var2, boolean var3);

    abstract IChromosome getSpecificChromosome(CompoundNBT var1, IChromosomeType var2);

    abstract boolean canLoad(CompoundNBT var1);
}

