/*
 * Decompiled with CFR 0.152.
 */
package genetics.items;

import genetics.ApiInstance;
import genetics.Genetics;
import genetics.api.IGeneTemplate;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IChromosomeType;
import genetics.api.root.IIndividualRoot;
import genetics.individual.RootDefinition;
import genetics.utils.AlleleUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class GeneTemplate
implements IGeneTemplate,
ICapabilitySerializable<CompoundNBT> {
    public static final IGeneTemplate EMPTY = new Empty();
    private static final String NBT_ALLELE = "Allele";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DEFINITION = "Definition";
    private final LazyOptional<IGeneTemplate> holder = LazyOptional.of(() -> this);
    @Nullable
    private IAllele allele;
    @Nullable
    private IChromosomeType type;
    @Nullable
    private IIndividualRoot root;

    @Override
    public Optional<IAllele> getAllele() {
        return Optional.ofNullable(this.allele);
    }

    @Override
    public Optional<IChromosomeType> getType() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public Optional<IIndividualRoot> getRoot() {
        return Optional.ofNullable(this.root);
    }

    @Override
    public void setAllele(@Nullable IChromosomeType type, @Nullable IAllele allele) {
        this.allele = allele;
        this.type = type;
        this.root = type != null ? type.getRoot() : null;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        if (this.allele != null) {
            compound.func_74778_a(NBT_ALLELE, this.allele.getRegistryName().toString());
        }
        if (this.type != null && this.root != null) {
            compound.func_74774_a(NBT_TYPE, (byte)this.type.getIndex());
            compound.func_74778_a(NBT_DEFINITION, this.root.getUID());
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        if (compound.func_74764_b(NBT_TYPE) && compound.func_74764_b(NBT_DEFINITION)) {
            ((RootDefinition)ApiInstance.INSTANCE.getRoot(compound.func_74779_i(NBT_DEFINITION))).ifPresent(def -> {
                this.root = def;
                this.type = def.getKaryotype().getChromosomeTypes()[compound.func_74771_c(NBT_TYPE)];
            });
        }
        if (compound.func_74764_b(NBT_ALLELE)) {
            this.allele = AlleleUtils.getAlleleOrNull(compound.func_74779_i(NBT_ALLELE));
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        return Genetics.GENE_TEMPLATE.orEmpty(cap, this.holder);
    }

    private static class Empty
    implements IGeneTemplate {
        private Empty() {
        }

        @Override
        public Optional<IAllele> getAllele() {
            return Optional.empty();
        }

        @Override
        public Optional<IChromosomeType> getType() {
            return Optional.empty();
        }

        @Override
        public Optional<IIndividualRoot> getRoot() {
            return Optional.empty();
        }

        @Override
        public void setAllele(@Nullable IChromosomeType type, @Nullable IAllele allele) {
        }
    }
}

