/*
 * Decompiled with CFR 0.152.
 */
package genetics.organism;

import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismHandler;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class OrganismHandler<I extends IIndividual>
implements IOrganismHandler<I> {
    public static final String INDIVIDUAL_KEY = "Individual";
    private final IRootDefinition<? extends IIndividualRoot<I>> optionalRoot;
    private final Supplier<ItemStack> stack;

    public OrganismHandler(IRootDefinition<? extends IIndividualRoot<I>> optionalRoot, Supplier<ItemStack> stack) {
        this.optionalRoot = optionalRoot;
        this.stack = stack;
    }

    @Override
    public ItemStack createStack(I individual) {
        ItemStack itemStack = this.stack.get();
        itemStack.func_77983_a(INDIVIDUAL_KEY, (INBT)individual.write(new CompoundNBT()));
        return itemStack;
    }

    @Override
    public Optional<I> createIndividual(ItemStack itemStack) {
        CompoundNBT tagCompound = itemStack.func_179543_a(INDIVIDUAL_KEY);
        if (tagCompound == null || !this.optionalRoot.isPresent()) {
            return Optional.empty();
        }
        IIndividualRoot<I> root = this.optionalRoot.get();
        return Optional.of(root.create(tagCompound));
    }

    @Override
    public boolean setIndividual(ItemStack itemStack, I individual) {
        itemStack.func_77983_a(INDIVIDUAL_KEY, (INBT)individual.write(new CompoundNBT()));
        return true;
    }

    @Override
    public void setIndividualData(ItemStack itemStack, CompoundNBT compound) {
        itemStack.func_77983_a(INDIVIDUAL_KEY, (INBT)compound);
    }

    @Override
    public CompoundNBT getIndividualData(ItemStack itemStack) {
        return itemStack.func_179543_a(INDIVIDUAL_KEY);
    }
}

