/*
 * Decompiled with CFR 0.152.
 */
package genetics.plugins;

import genetics.api.GeneticPlugin;
import genetics.api.IGeneticPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class PluginUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private PluginUtil() {
    }

    public static Map<IGeneticPlugin, ModContainer> getPlugins() {
        Type annotationType = Type.getType(GeneticPlugin.class);
        List allScanData = ModList.get().getAllScanData();
        Function<String, Optional> getContainer = modId -> ModList.get().getModContainerById(modId);
        ArrayList<String> pluginClassNames = new ArrayList<String>();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.getAnnotationType(), annotationType)) continue;
                String memberName = a.getMemberName();
                pluginClassNames.add(memberName);
            }
        }
        HashMap<IGeneticPlugin, ModContainer> instances = new HashMap<IGeneticPlugin, ModContainer>();
        HashSet<String> loadedClasses = new HashSet<String>();
        for (String className : pluginClassNames) {
            if (loadedClasses.contains(className)) continue;
            try {
                Class<?> asmClass = Class.forName(className);
                Class<IGeneticPlugin> asmInstanceClass = asmClass.asSubclass(IGeneticPlugin.class);
                IGeneticPlugin instance = asmInstanceClass.newInstance();
                GeneticPlugin plugin = asmInstanceClass.getAnnotation(GeneticPlugin.class);
                if (plugin == null) continue;
                Optional modContainer = getContainer.apply(plugin.modId());
                modContainer.ifPresent(container -> instances.put(instance, (ModContainer)container));
                loadedClasses.add(className);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            }
        }
        return instances;
    }
}

