/*
 * Decompiled with CFR 0.152.
 */
package genetics.root;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import genetics.ApiInstance;
import genetics.alleles.AlleleTemplateBuilder;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.events.RootBuilderEvents;
import genetics.api.events.RootEvent;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.root.IGeneticListener;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IIndividualRootBuilder;
import genetics.api.root.IIndividualRootFactory;
import genetics.api.root.IRootContext;
import genetics.api.root.SimpleIndividualRoot;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.components.IRootComponent;
import genetics.api.root.components.IRootComponentFactory;
import genetics.individual.Karyotype;
import genetics.individual.RootDefinition;
import genetics.root.RootComponentRegistry;
import genetics.root.RootContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class IndividualRootBuilder<I extends IIndividual>
implements IIndividualRootBuilder<I> {
    public final String uid;
    private final List<IChromosomeType> chromosomeTypes = new ArrayList<IChromosomeType>();
    @Nullable
    private IChromosomeType speciesType;
    private final Multimap<ComponentKey, Consumer> componentListeners = HashMultimap.create();
    private final Map<ComponentKey, IRootComponentFactory> componentFactories = new HashMap<ComponentKey, IRootComponentFactory>();
    private final RootDefinition<IIndividualRoot<I>> definition;
    private BiFunction<IKaryotype, IAllele[], IAlleleTemplateBuilder> templateFactory = AlleleTemplateBuilder::new;
    @Nullable
    private Function<IAlleleTemplateBuilder, IAlleleTemplate> defaultTemplate;
    @Nullable
    private IIndividualRootFactory<I, IIndividualRoot<I>> rootFactory;

    IndividualRootBuilder(String uid) {
        this.uid = uid;
        this.definition = ApiInstance.INSTANCE.getRoot(uid);
        this.addComponent(ComponentKeys.TEMPLATES);
        this.addComponent(ComponentKeys.TYPES);
    }

    @Override
    public IIndividualRootBuilder<I> addChromosome(IChromosomeType type) {
        this.chromosomeTypes.add(type);
        if (this.speciesType == null) {
            this.speciesType = type;
        }
        return this;
    }

    @Override
    public IIndividualRootBuilder<I> addChromosome(IChromosomeType ... types) {
        if (this.speciesType == null && types.length > 0) {
            this.speciesType = types[0];
        }
        this.chromosomeTypes.addAll(Arrays.asList(types));
        return this;
    }

    @Override
    public IIndividualRootBuilder<I> setSpeciesType(IChromosomeType speciesType) {
        this.speciesType = speciesType;
        if (!this.chromosomeTypes.contains(speciesType)) {
            this.addChromosome(speciesType);
        }
        return this;
    }

    @Override
    public IIndividualRootBuilder<I> setRootFactory(IIndividualRootFactory<I, IIndividualRoot<I>> rootFactory) {
        this.rootFactory = rootFactory;
        return this;
    }

    @Override
    public IIndividualRootBuilder<I> setRootFactory(Class<? extends I> individualClass) {
        return this.setRootFactory((IRootContext<I> context) -> new SimpleIndividualRoot(context, individualClass));
    }

    @Override
    public IIndividualRootBuilder<I> setDefaultTemplate(Function<IAlleleTemplateBuilder, IAlleleTemplate> defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
        return this;
    }

    @Override
    public IIndividualRootBuilder<I> setTemplateFactory(BiFunction<IKaryotype, IAllele[], IAlleleTemplateBuilder> templateFactory) {
        this.templateFactory = templateFactory;
        return this;
    }

    public void create(Collection<IGeneticListener<I>> listeners) {
        Preconditions.checkNotNull((Object)this.speciesType);
        Preconditions.checkNotNull(this.templateFactory);
        Preconditions.checkNotNull(this.defaultTemplate);
        Preconditions.checkNotNull(this.rootFactory);
        Karyotype karyotype = new Karyotype(this.uid, this.chromosomeTypes, this.speciesType, this.templateFactory, this.defaultTemplate);
        this.definition.setRoot(this.rootFactory.createRoot(new RootContext<I>(karyotype, listeners, this.componentListeners, root -> {
            HashMap<ComponentKey, IRootComponent> components = new HashMap<ComponentKey, IRootComponent>();
            this.componentFactories.forEach((componentKey, factory) -> {
                IRootComponent cfr_ignored_0 = (IRootComponent)components.put((ComponentKey)componentKey, (IRootComponent)factory.create(root));
            });
            components.forEach((componentKey, builder) -> {
                FMLJavaModLoadingContext.get().getModEventBus().post(new RootBuilderEvents.CreateComponent(this, (ComponentKey<?>)componentKey, (IRootComponent)builder));
                components.put((ComponentKey)componentKey, (IRootComponent)builder);
            });
            return components;
        })));
        MinecraftForge.EVENT_BUS.register(new RootEvent.CreationEvent<IIndividualRoot<I>>(this.definition));
    }

    @Override
    public <R extends IIndividualRoot<I>> RootDefinition<R> getDefinition() {
        return this.definition;
    }

    @Override
    public IIndividualRootBuilder<I> addComponent(ComponentKey key) {
        IRootComponentFactory factory = RootComponentRegistry.INSTANCE.getFactory(key);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("No component factory was registered for the component key '%s'.", key));
        }
        this.componentFactories.put(key, factory);
        return this;
    }

    @Override
    public <C extends IRootComponent<I>> IIndividualRootBuilder<I> addComponent(ComponentKey key, IRootComponentFactory<I, C> factory) {
        this.componentFactories.put(key, factory);
        return this;
    }

    @Override
    public <C extends IRootComponent<I>> IIndividualRootBuilder<I> addListener(ComponentKey key, Consumer<C> consumer) {
        if (!this.componentFactories.containsKey(key)) {
            throw new IllegalArgumentException(String.format("No component factory was added for the component key '%s'. Please call 'addComponent' before 'addListener'.", key));
        }
        this.componentListeners.put((Object)key, consumer);
        return this;
    }
}

