/*
 * Decompiled with CFR 0.152.
 */
package genetics.root;

import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.components.IRootComponentFactory;
import genetics.api.root.components.IRootComponentRegistry;
import genetics.organism.OrganismTypes;
import genetics.root.IndividualTranslator;
import genetics.root.MutationContainer;
import genetics.root.TemplateContainer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public enum RootComponentRegistry implements IRootComponentRegistry
{
    INSTANCE;

    private final Map<ComponentKey, IRootComponentFactory> factoryByKey = new HashMap<ComponentKey, IRootComponentFactory>();

    private RootComponentRegistry() {
        this.registerFactory((ComponentKey)ComponentKeys.TEMPLATES, TemplateContainer::new);
        this.registerFactory((ComponentKey)ComponentKeys.TYPES, OrganismTypes::new);
        this.registerFactory((ComponentKey)ComponentKeys.TRANSLATORS, IndividualTranslator::new);
        this.registerFactory((ComponentKey)ComponentKeys.MUTATIONS, MutationContainer::new);
    }

    public void registerFactory(ComponentKey key, IRootComponentFactory factory) {
        this.factoryByKey.put(key, factory);
    }

    @Override
    @Nullable
    public IRootComponentFactory getFactory(ComponentKey key) {
        return this.factoryByKey.get(key);
    }
}

