/*
 * Decompiled with CFR 0.152.
 */
package genetics.root;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import genetics.api.GeneticsAPI;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IIndividual;
import genetics.api.root.IGeneticListener;
import genetics.api.root.IGeneticListenerRegistry;
import genetics.api.root.IIndividualRootBuilder;
import genetics.api.root.IRootManager;
import genetics.root.IndividualRootBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class RootManager
implements IRootManager,
IGeneticListenerRegistry {
    private final HashMap<String, IndividualRootBuilder> rootBuilders = new HashMap();
    private final Multimap<String, IGeneticListener> listeners = HashMultimap.create();

    @Override
    public <I extends IIndividual> IIndividualRootBuilder<I> createRoot(String uid) {
        IndividualRootBuilder builder = new IndividualRootBuilder(uid);
        builder.addChromosome(GeneticsAPI.apiInstance.getChromosomeList(uid).typesArray());
        this.rootBuilders.put(uid, builder);
        return builder;
    }

    @Override
    public <I extends IIndividual, T extends Enum<T>> IIndividualRootBuilder<I> createRoot(String uid, Class<? extends T> enumClass) {
        Enum[] types = (Enum[])enumClass.getEnumConstants();
        if (types.length <= 0) {
            throw new IllegalArgumentException("The given enum class must contain at least one enum constant.");
        }
        IndividualRootBuilder builder = new IndividualRootBuilder(uid);
        for (int i = 1; i < types.length; ++i) {
            IChromosomeType type = (IChromosomeType)((Object)types[i]);
            builder.addChromosome(type);
        }
        this.rootBuilders.put(uid, builder);
        return builder;
    }

    @Override
    public <I extends IIndividual> Optional<IIndividualRootBuilder<I>> getRoot(String uid) {
        return Optional.ofNullable(this.rootBuilders.get(uid));
    }

    @Override
    public void add(String uid, IGeneticListener listener) {
        this.listeners.put((Object)uid, (Object)listener);
    }

    @Override
    public void add(String uid, IGeneticListener ... listeners) {
        this.add(uid, Lists.newArrayList((Object[])listeners));
    }

    @Override
    public void add(String uid, Collection<IGeneticListener> listeners) {
        this.listeners.putAll((Object)uid, listeners);
    }

    public Collection<IGeneticListener> getListeners(String uid) {
        return this.listeners.get((Object)uid);
    }

    public Multimap<String, IGeneticListener> getListeners() {
        return this.listeners;
    }

    public Map<String, IndividualRootBuilder> getRootBuilders() {
        return this.rootBuilders;
    }
}

