/*
 * Decompiled with CFR 0.152.
 */
package genetics.utils;

import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeAllele;
import genetics.api.individual.IChromosomeType;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class AlleleUtils {
    private AlleleUtils() {
    }

    public static boolean isBlacklisted(IAllele allele) {
        return AlleleUtils.isBlacklisted(allele.getRegistryName());
    }

    public static boolean isBlacklisted(String registryName) {
        return AlleleUtils.isBlacklisted(new ResourceLocation(registryName));
    }

    public static boolean isBlacklisted(ResourceLocation registryName) {
        return GeneticsAPI.apiInstance.getAlleleRegistry().isBlacklisted(registryName);
    }

    @Nullable
    public static <A extends IAllele> A getAlleleOrNull(String registryName) {
        return AlleleUtils.getAlleleOrNull(new ResourceLocation(registryName));
    }

    @Nullable
    public static <A extends IAllele> A getAlleleOrNull(ResourceLocation registryName) {
        Optional<A> optional = AlleleUtils.getAllele(registryName);
        return (A)((IAllele)optional.orElse(null));
    }

    public static <A extends IAllele> A getAlleleOr(String registryName, A fallback) {
        return AlleleUtils.getAlleleOr(new ResourceLocation(registryName), fallback);
    }

    public static <A extends IAllele> A getAlleleOr(ResourceLocation registryName, A fallback) {
        Optional<A> optional = AlleleUtils.getAllele(registryName);
        return (A)((IAllele)optional.orElse(fallback));
    }

    public static <A extends IAllele> Optional<A> getAllele(ResourceLocation registryName) {
        Optional<IAllele> optional = GeneticsAPI.apiInstance.getAlleleRegistry().getAllele(registryName);
        return optional.map(allele -> allele);
    }

    public static <A extends IAllele> Optional<A> getAllele(String registryName) {
        return AlleleUtils.getAllele(new ResourceLocation(registryName));
    }

    public static void actOn(ResourceLocation location, Consumer<IAllele> alleleAction) {
        AlleleUtils.actOn(location, IAllele.class, alleleAction);
    }

    public static <R> R callOn(ResourceLocation location, Function<IAllele, R> alleleAction, R fallback) {
        return AlleleUtils.callOn(location, IAllele.class, alleleAction, fallback);
    }

    public static <A extends IAllele> void actOn(ResourceLocation location, Class<? extends A> alleleClass, Consumer<A> alleleAction) {
        A allele = AlleleUtils.getAlleleOrNull(location);
        if (!alleleClass.isInstance(allele)) {
            return;
        }
        IAllele castedAllele = (IAllele)alleleClass.cast(allele);
        alleleAction.accept(castedAllele);
    }

    public static <A extends IAllele, R> R callOn(ResourceLocation location, Class<? extends A> alleleClass, Function<A, R> alleleAction, R fallback) {
        A allele = AlleleUtils.getAlleleOrNull(location);
        if (!alleleClass.isInstance(allele)) {
            return fallback;
        }
        IAllele castedAllele = (IAllele)alleleClass.cast(allele);
        return alleleAction.apply(castedAllele);
    }

    public static Collection<ResourceLocation> getRegisteredNames() {
        return GeneticsAPI.apiInstance.getAlleleRegistry().getRegisteredNames();
    }

    public static Collection<IAllele> getAlleles() {
        return GeneticsAPI.apiInstance.getAlleleRegistry().getRegisteredAlleles();
    }

    public static Collection<IChromosomeType> getChromosomeTypes(IAllele allele) {
        return GeneticsAPI.apiInstance.getAlleleRegistry().getChromosomeTypes(allele);
    }

    public static Collection<IAllele> getAllelesByType(IChromosomeType type) {
        return GeneticsAPI.apiInstance.getAlleleRegistry().getRegisteredAlleles(type);
    }

    public static <A extends IAllele> Collection<A> filteredAlleles(IChromosomeAllele<A> type) {
        return AlleleUtils.filteredStream(type).collect(Collectors.toSet());
    }

    public static <A extends IAllele> void forEach(IChromosomeAllele<A> type, Consumer<A> action) {
        AlleleUtils.filteredStream(type).forEach(action);
    }

    public static <A extends IAllele> Stream<A> filteredStream(IChromosomeAllele<A> type) {
        return AlleleUtils.getAllelesByType(type).stream().filter(allele -> type.getAlleleClass().isInstance(allele)).map(type::castAllele);
    }

    public static <V> V getAlleleValue(IAllele allele, Class<? extends V> valueClass, V fallback) {
        if (!(allele instanceof IAlleleValue)) {
            return fallback;
        }
        IAlleleValue alleleValue = (IAlleleValue)allele;
        Object value = alleleValue.getValue();
        if (valueClass.isInstance(value)) {
            return valueClass.cast(value);
        }
        return fallback;
    }

    @Nullable
    public static <V> V getAlleleValue(IAllele allele, Class<? extends V> valueClass) {
        if (!(allele instanceof IAlleleValue)) {
            return null;
        }
        IAlleleValue alleleValue = (IAlleleValue)allele;
        Object value = alleleValue.getValue();
        if (valueClass.isInstance(value)) {
            return valueClass.cast(value);
        }
        return null;
    }
}

