/*
 * Decompiled with CFR 0.152.
 */
package genetics.utils;

import genetics.ApiInstance;
import genetics.alleles.AlleleRegistry;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IKaryotype;
import genetics.individual.Chromosome;
import genetics.individual.ChromosomeInfo;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class SimpleByteBuf {
    private static final int DEFAULT_INITIAL_CAPACITY = 22;
    private byte[] data;
    private int bufferIndex;

    public SimpleByteBuf() {
        this(22);
    }

    public SimpleByteBuf(int initialCapacity) {
        this.data = new byte[initialCapacity];
    }

    public SimpleByteBuf(byte[] data) {
        this.data = data;
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public void writeChromosomes(IChromosome[] chromosomes, IKaryotype karyotype) {
        for (IChromosomeType type : karyotype) {
            int index = type.getIndex();
            if (index >= chromosomes.length) continue;
            IChromosome chromosome = chromosomes[index];
            this.writeAllele(chromosome.getActiveAllele());
            this.writeAllele(chromosome.getInactiveAllele());
        }
    }

    private void writeAllele(IAllele allele) {
        int id;
        AlleleRegistry registry = ApiInstance.INSTANCE.alleleRegistry;
        int n = id = registry == null ? -1 : registry.getId(allele);
        if (id < 0) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(id);
    }

    private void writeVarInt(int input) {
        while ((input & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(input & 0x7F | 0x80));
            input >>>= 7;
        }
        this.writeByte((byte)input);
    }

    private void writeByte(int input) {
        if (input > 255) {
            throw new IllegalArgumentException();
        }
        this.ensureCapacity(this.bufferIndex + 1);
        this.data[this.bufferIndex++] = (byte)input;
    }

    private void ensureCapacity(int capacity) {
        if (capacity - this.data.length > 0) {
            this.data = Arrays.copyOf(this.data, this.data.length + 1);
        }
    }

    public IChromosome[] readChromosomes(IKaryotype karyotype) {
        IChromosomeType[] types = karyotype.getChromosomeTypes();
        IChromosome[] chromosomes = new IChromosome[types.length];
        ResourceLocation primaryTemplateIdentifier = null;
        ResourceLocation secondaryTemplateIdentifier = null;
        for (IChromosomeType type : types) {
            int index = type.getIndex();
            Chromosome chromosome = this.readChromosome(type, primaryTemplateIdentifier, secondaryTemplateIdentifier);
            chromosomes[index] = chromosome;
            if (!type.equals(karyotype.getSpeciesType())) continue;
            primaryTemplateIdentifier = chromosome.getActiveAllele().getRegistryName();
            secondaryTemplateIdentifier = chromosome.getInactiveAllele().getRegistryName();
        }
        return chromosomes;
    }

    private Chromosome readChromosome(IChromosomeType type, @Nullable ResourceLocation activeSpeciesUid, @Nullable ResourceLocation inactiveSpeciesUid) {
        IAllele firstAllele = this.readAllele();
        IAllele secondAllele = this.readAllele();
        return Chromosome.create(activeSpeciesUid, inactiveSpeciesUid, type, firstAllele, secondAllele);
    }

    @Nullable
    private IAllele readAllele() {
        AlleleRegistry registry = ApiInstance.INSTANCE.alleleRegistry;
        int id = this.readVarInt();
        if (registry == null) {
            return null;
        }
        return registry.getAllele(id);
    }

    private int readVarInt() {
        byte b0;
        int output = 0;
        int byteCount = 0;
        do {
            b0 = this.readByte();
            output |= (b0 & 0x7F) << byteCount++ * 7;
            if (byteCount <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return output;
    }

    private byte readByte() {
        if (this.bufferIndex < 0 || this.bufferIndex >= this.data.length) {
            return -1;
        }
        return this.data[this.bufferIndex++];
    }

    private Chromosome readChromosome(IChromosomeType type, ChromosomeInfo info) {
        return this.readChromosome(type, info.activeSpeciesUid, info.inactiveSpeciesUid);
    }

    public ChromosomeInfo readChromosome(IChromosomeType geneType) {
        IKaryotype karyotype = geneType.getRoot().getKaryotype();
        IChromosomeType[] keys = karyotype.getChromosomeTypes();
        ChromosomeInfo info = new ChromosomeInfo(geneType);
        for (IChromosomeType key : keys) {
            if (geneType.equals(key)) {
                return info.setChromosome(this.readChromosome(key, info));
            }
            if (karyotype.getSpeciesType().equals(key)) {
                Chromosome chromosome = this.readChromosome(key, info);
                info.setSpeciesInfo(chromosome.getActiveAllele().getRegistryName(), chromosome.getInactiveAllele().getRegistryName());
                continue;
            }
            this.readVarInt();
            this.readVarInt();
        }
        return info;
    }
}

