/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.jei;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import mezz.jei.ingredients.IngredientFilter;
import net.darkhax.bookshelf.util.ModUtils;
import net.darkhax.enchdesc.EnchantmentDescriptions;
import net.darkhax.enchdesc.EnchantmentDescriptionsClient;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentInfoEntry
implements IRecipeCategoryExtension {
    private final Enchantment enchantment;
    private final ITextComponent name;
    private final ITextComponent description;
    private final int maxLevel;
    private final List<Enchantment> incompatibleEnchantments;
    private final List<ItemStack> books;
    private final List<ItemStack> compatibleItems;
    private static Map<Enchantment, NonNullList<ItemStack>> compatibleItemsCache;

    public EnchantmentInfoEntry(Enchantment enchantment) {
        this.enchantment = enchantment;
        this.name = new TranslationTextComponent(enchantment.func_77320_a()).func_240699_a_(TextFormatting.BLACK);
        this.description = EnchantmentDescriptionsClient.getDescription(enchantment).func_230532_e_().func_240699_a_(TextFormatting.BLACK);
        this.maxLevel = enchantment.func_77325_b();
        this.incompatibleEnchantments = EnchantmentInfoEntry.getIncompatibleEnchantments(enchantment);
        this.books = EnchantmentInfoEntry.getEnchantedBooks(enchantment);
        this.compatibleItems = EnchantmentInfoEntry.getCompatibleItems(enchantment);
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.compatibleItems);
        ingredients.setOutputs(VanillaTypes.ITEM, this.books);
    }

    public ITextComponent getName() {
        return this.name;
    }

    public ITextComponent getDescription() {
        return this.description;
    }

    public String getDescriptionKey() {
        return this.enchantment.func_77320_a() + ".desc";
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public List<Enchantment> getIncompatibleEnchantments() {
        return this.incompatibleEnchantments;
    }

    public List<ItemStack> getBooks() {
        return this.books;
    }

    public List<ItemStack> getCompatibleItems() {
        IngredientFilter filter = Internal.getIngredientFilter();
        return this.compatibleItems.stream().filter(arg_0 -> ((IngredientFilter)filter).isIngredientVisible(arg_0)).collect(Collectors.toList());
    }

    public void getTooltip(int slotIndex, boolean input, ItemStack stack, List<ITextComponent> tooltip) {
        if (this.enchantment.canApplyAtEnchantingTable(stack) && !this.enchantment.func_185261_e()) {
            tooltip.add((ITextComponent)Blocks.field_150381_bn.func_235333_g_().func_240699_a_(TextFormatting.GREEN));
        }
        if (this.enchantment.func_92089_a(stack)) {
            tooltip.add((ITextComponent)Blocks.field_150467_bQ.func_235333_g_().func_240699_a_(TextFormatting.GREEN));
        }
    }

    private static NonNullList<ItemStack> getCompatibleItems(Enchantment enchantment) {
        if (compatibleItemsCache == null) {
            EnchantmentInfoEntry.buildCompatibilityCache();
        }
        return compatibleItemsCache.getOrDefault(enchantment, (NonNullList<ItemStack>)NonNullList.func_191196_a());
    }

    private static void buildCompatibilityCache() {
        compatibleItemsCache = new HashMap<Enchantment, NonNullList<ItemStack>>();
        for (Item item : ForgeRegistries.ITEMS) {
            try {
                ItemStack stack = new ItemStack((IItemProvider)item);
                if (!stack.func_77956_u()) continue;
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                    if (!enchantment.func_92089_a(stack) && !enchantment.canApplyAtEnchantingTable(stack)) continue;
                    compatibleItemsCache.computeIfAbsent(enchantment, e -> NonNullList.func_191196_a()).add((Object)stack);
                }
            }
            catch (Exception e2) {
                String modName = ModUtils.getOwner((IForgeRegistryEntry)item).getModInfo().getDisplayName();
                EnchantmentDescriptions.LOG.error("Failed to determine enchantment compatibility for Item \"{}\" from the \"{}\" mod.", (Object)item.getRegistryName(), (Object)modName);
                EnchantmentDescriptions.LOG.catching((Throwable)e2);
            }
        }
    }

    private static List<Enchantment> getIncompatibleEnchantments(Enchantment enchantment) {
        NonNullList incompatible = NonNullList.func_191196_a();
        for (Enchantment other : ForgeRegistries.ENCHANTMENTS) {
            if (other == enchantment || enchantment.func_191560_c(other)) continue;
            incompatible.add(other);
        }
        return incompatible;
    }

    private static List<ItemStack> getEnchantedBooks(Enchantment enchantment) {
        NonNullList books = NonNullList.func_191196_a();
        for (int lvl = enchantment.func_77319_d(); lvl <= enchantment.func_77325_b(); ++lvl) {
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantedBookItem.func_92115_a((ItemStack)book, (EnchantmentData)new EnchantmentData(enchantment, lvl));
            books.add(book);
        }
        return books;
    }
}

