/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.core;

import com.agricraft.agricore.config.AgriConfigAdapter;
import com.agricraft.agricore.defaults.AgriDefaultConfig;
import com.agricraft.agricore.defaults.AgriDefaultConverter;
import com.agricraft.agricore.defaults.AgriDefaultLog;
import com.agricraft.agricore.defaults.AgriDefaultValidator;
import com.agricraft.agricore.log.AgriLogAdapter;
import com.agricraft.agricore.log.AgriLogManager;
import com.agricraft.agricore.log.AgriLogger;
import com.agricraft.agricore.registry.AgriFertilizers;
import com.agricraft.agricore.registry.AgriMutations;
import com.agricraft.agricore.registry.AgriPlants;
import com.agricraft.agricore.registry.AgriSoils;
import com.agricraft.agricore.registry.AgriWeeds;
import com.agricraft.agricore.util.AgriConverter;
import com.agricraft.agricore.util.AgriValidator;

public final class AgriCore {
    private static AgriLogManager logManager = new AgriLogManager(new AgriDefaultLog());
    private static AgriValidator validator;
    private static AgriConverter converter;
    private static AgriPlants plants;
    private static AgriWeeds weeds;
    private static AgriMutations mutations;
    private static AgriSoils soils;
    private static AgriFertilizers fertilizers;
    private static AgriConfigAdapter config;

    private AgriCore() {
    }

    public static void init(AgriLogAdapter log, AgriValidator validator, AgriConverter converter, AgriConfigAdapter config) {
        logManager = new AgriLogManager(log);
        AgriCore.config = config;
        AgriLogger logger = AgriCore.getCoreLogger();
        logger.info("Initializing core!", new Object[0]);
        AgriCore.validator = validator;
        AgriCore.converter = converter;
        plants = new AgriPlants();
        weeds = new AgriWeeds();
        mutations = new AgriMutations();
        soils = new AgriSoils();
        fertilizers = new AgriFertilizers();
        logger.info("Initialized core!", new Object[0]);
    }

    public static AgriLogger getCoreLogger() {
        return AgriCore.getLogger("agricore");
    }

    public static AgriLogger getLogger(Object source) {
        return logManager.getLogger(source);
    }

    public static AgriLogManager getLogManager() {
        return logManager;
    }

    public static AgriValidator getValidator() {
        return validator;
    }

    public static AgriConverter getConverter() {
        return converter;
    }

    public static AgriConfigAdapter getConfig() {
        return config;
    }

    public static AgriMutations getMutations() {
        return mutations;
    }

    public static AgriPlants getPlants() {
        return plants;
    }

    public static AgriWeeds getWeeds() {
        return weeds;
    }

    public static AgriSoils getSoils() {
        return soils;
    }

    public static AgriFertilizers getFertilizers() {
        return fertilizers;
    }

    static {
        config = new AgriDefaultConfig();
        validator = new AgriDefaultValidator();
        converter = new AgriDefaultConverter();
        plants = new AgriPlants();
        weeds = new AgriWeeds();
        mutations = new AgriMutations();
        soils = new AgriSoils();
        fertilizers = new AgriFertilizers();
    }
}

