/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.log;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.log.AgriLogAdapter;
import java.util.Objects;

public class AgriLogger {
    private final AgriLogAdapter adapter;
    private final Object source;

    AgriLogger(AgriLogAdapter adapter, Object source) {
        this.adapter = adapter;
        this.source = source;
    }

    public boolean isEnabled() {
        return AgriCore.getConfig().enableLogging();
    }

    public void all(Object format, Object ... objects) {
        if (this.isEnabled()) {
            this.adapter.all(this.source, Objects.toString(format), objects);
        }
    }

    public void severe(Object format, Object ... objects) {
        if (this.isEnabled()) {
            this.adapter.severe(this.source, Objects.toString(format), objects);
        }
    }

    public void info(Object format, Object ... objects) {
        if (this.isEnabled()) {
            this.adapter.info(this.source, Objects.toString(format), objects);
        }
    }

    public void warn(Object format, Object ... objects) {
        if (this.isEnabled()) {
            this.adapter.warn(this.source, Objects.toString(format), objects);
        }
    }

    public void debug(Object format, Object ... objects) {
        if (this.isEnabled()) {
            this.adapter.debug(this.source, Objects.toString(format), objects);
        }
    }

    public void error(Object format, Object ... objects) {
        if (this.isEnabled()) {
            this.adapter.error(this.source, Objects.toString(format), objects);
        }
    }

    public void trace(Exception e) {
        if (this.isEnabled()) {
            this.adapter.trace(this.source, e);
        }
    }
}

