/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriSerializable;
import com.agricraft.agricore.plant.AgriProductList;
import com.agricraft.agricore.plant.AgriRequirement;
import com.agricraft.agricore.plant.AgriSeed;
import com.agricraft.agricore.plant.AgriTexture;
import com.agricraft.agricore.plant.particle.AgriParticleEffect;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;

public class AgriPlant
implements AgriSerializable,
Comparable<AgriPlant> {
    private String path;
    private final String version;
    private final String json_documentation = "https://agridocs.readthedocs.io/en/master/agri_plant/";
    private final boolean enabled;
    private final List<String> mods;
    private final String id;
    private final String plant_lang_key;
    private final String seed_lang_key;
    private final String desc_lang_key;
    private final List<AgriSeed> seed_items;
    private final int[] stages;
    private final int harvestStage;
    private final double growth_chance;
    private final double growth_bonus;
    private final int tier;
    private final boolean cloneable;
    private final double spread_chance;
    private final double grass_drop_chance;
    private final double seed_drop_chance;
    private final double seed_drop_bonus;
    private final AgriProductList products;
    private final AgriProductList clip_products;
    private final AgriRequirement requirement;
    private final List<JsonElement> callbacks;
    private final AgriTexture texture;
    private final String seed_texture;
    private final String seed_model;
    private final List<AgriParticleEffect> particle_effects;

    public AgriPlant() {
        this.enabled = false;
        this.mods = Lists.newArrayList((Object[])new String[]{"agricraft", "minecraft"});
        this.path = "default/weed_plant.json";
        this.version = "1.16.4";
        this.id = "weed_plant";
        this.plant_lang_key = "agricraft.plant.weeds";
        this.seed_lang_key = "agricraft.seed.weeds";
        this.desc_lang_key = "agricraft.plant.weeds.desc";
        this.seed_items = Lists.newArrayList();
        this.stages = new int[]{2, 4, 6, 8, 10, 12, 14, 16};
        this.harvestStage = 4;
        this.tier = 1;
        this.cloneable = true;
        this.growth_chance = 0.9;
        this.growth_bonus = 0.025;
        this.spread_chance = 0.1;
        this.grass_drop_chance = 0.0;
        this.seed_drop_chance = 1.0;
        this.seed_drop_bonus = 0.0;
        this.products = new AgriProductList();
        this.clip_products = new AgriProductList();
        this.requirement = new AgriRequirement();
        this.callbacks = new ArrayList<JsonElement>();
        this.texture = new AgriTexture();
        this.seed_texture = "minecraft:item/wheat_seeds";
        this.seed_model = "minecraft:item/wheat_seeds";
        this.particle_effects = new ArrayList<AgriParticleEffect>();
    }

    public AgriPlant(String id, String plant_lang_key, String seed_lang_key, String desc_lang_key, List<AgriSeed> seed_items, int[] stages, int harvestStage, int tier, double growth_chance, double growth_bonus, boolean cloneable, double spread_chance, double grass_drop_chance, double seed_drop_chance, double seed_drop_bonus, AgriProductList products, AgriProductList clip_products, AgriRequirement requirement, List<JsonElement> callbacks, AgriTexture texture, String seed_texture, String seed_model, List<AgriParticleEffect> particle_effects, String path, boolean enabled) {
        this(id, plant_lang_key, seed_lang_key, desc_lang_key, seed_items, stages, harvestStage, tier, growth_chance, growth_bonus, cloneable, spread_chance, grass_drop_chance, seed_drop_chance, seed_drop_bonus, products, clip_products, requirement, callbacks, texture, seed_texture, seed_model, particle_effects, path, enabled, Lists.newArrayList((Object[])new String[]{"agricraft", "minecraft"}));
    }

    public AgriPlant(String id, String plant_lang_key, String seed_lang_key, String desc_lang_key, List<AgriSeed> seed_items, int[] stages, int harvestStage, int tier, double growth_chance, double growth_bonus, boolean cloneable, double spread_chance, double grass_drop_chance, double seed_drop_chance, double seed_drop_bonus, AgriProductList products, AgriProductList clip_products, AgriRequirement requirement, List<JsonElement> callbacks, AgriTexture texture, String seed_texture, String seed_model, List<AgriParticleEffect> particle_effects, String path, boolean enabled, List<String> mods) {
        Preconditions.checkArgument((stages.length > 0 ? 1 : 0) != 0, (Object)"The number of stages must be larger than 0");
        Preconditions.checkArgument((harvestStage >= 0 ? 1 : 0) != 0, (Object)"The harvest index can not be negative");
        Preconditions.checkArgument((harvestStage < stages.length ? 1 : 0) != 0, (Object)"The harvest index must be smaller than the number of stages");
        this.enabled = enabled;
        this.mods = mods;
        this.path = path;
        this.id = id;
        this.plant_lang_key = plant_lang_key;
        this.seed_lang_key = seed_lang_key;
        this.desc_lang_key = desc_lang_key;
        this.seed_items = seed_items;
        this.stages = stages;
        this.harvestStage = harvestStage;
        this.tier = tier;
        this.growth_chance = growth_chance;
        this.growth_bonus = growth_bonus;
        this.spread_chance = spread_chance;
        this.grass_drop_chance = grass_drop_chance;
        this.seed_drop_chance = seed_drop_chance;
        this.seed_drop_bonus = seed_drop_bonus;
        this.products = products;
        this.clip_products = clip_products;
        this.cloneable = cloneable;
        this.requirement = requirement;
        this.callbacks = callbacks;
        this.texture = texture;
        this.seed_texture = seed_texture;
        this.seed_model = seed_model;
        this.particle_effects = particle_effects;
        this.version = "1.16.4";
    }

    public String getId() {
        return this.id;
    }

    public String getPlantLangKey() {
        return this.plant_lang_key;
    }

    public String getSeedLangKey() {
        return this.seed_lang_key;
    }

    public String getDescLangKey() {
        return this.desc_lang_key;
    }

    public List<AgriSeed> getSeeds() {
        return this.seed_items;
    }

    public int getGrowthStages() {
        return this.stages.length;
    }

    public int getGrowthStageHeight(int stage) {
        return this.stages[stage];
    }

    public int getStageAfterHarvest() {
        return this.harvestStage;
    }

    public AgriProductList getProducts() {
        return this.products;
    }

    public AgriProductList getClipProducts() {
        return this.clip_products;
    }

    public boolean allowsCloning() {
        return this.cloneable;
    }

    public AgriRequirement getRequirement() {
        return this.requirement;
    }

    public AgriTexture getTexture() {
        return this.texture;
    }

    public String getSeedTexture() {
        return this.seed_texture;
    }

    public String getSeedModel() {
        return this.seed_model;
    }

    public List<AgriParticleEffect> getParticleEffects() {
        return this.particle_effects;
    }

    public int getTier() {
        return this.tier;
    }

    public double getSpreadChance() {
        return this.spread_chance;
    }

    public double getGrowthChance() {
        return this.growth_chance;
    }

    public double getGrowthBonus() {
        return this.growth_bonus;
    }

    public double getGrassDropChance() {
        return this.grass_drop_chance;
    }

    public double getSeedDropChance() {
        return this.seed_drop_chance;
    }

    public double getSeedDropBonus() {
        return this.seed_drop_bonus;
    }

    public List<JsonElement> getCallbacks() {
        return this.callbacks;
    }

    public boolean validate() {
        if (!this.enabled) {
            AgriCore.getCoreLogger().info("Disabled Plant: {0}!", this.id);
            return false;
        }
        if (!this.requirement.validate()) {
            AgriCore.getCoreLogger().info("Invalid Plant: {0}! Invalid Requirement!", this.id);
            return false;
        }
        if (!this.products.validate()) {
            AgriCore.getCoreLogger().info("Invalid Plant: {0}! Invalid Product!", this.id);
            return false;
        }
        if (!this.clip_products.validate()) {
            AgriCore.getCoreLogger().info("Invalid Plant: {0}! Invalid Clip Product!", this.id);
            return false;
        }
        if (!this.texture.validate()) {
            AgriCore.getCoreLogger().info("Invalid Plant: {0}! Invalid Texture!", this.id);
            return false;
        }
        if (!AgriCore.getValidator().isValidResource(this.seed_model)) {
            AgriCore.getCoreLogger().info("Invalid AgriTexture! Invalid Seed Model: \"{0}\"!", this.seed_model);
            return false;
        }
        this.particle_effects.removeIf(particleEffect -> !particleEffect.validate());
        this.seed_items.removeIf(seed -> !seed.validate());
        this.callbacks.removeIf(callback -> !AgriCore.getValidator().isValidCallback((JsonElement)callback));
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(this.id).append(":\n");
        sb.append("\t- Growth Chance: ").append(this.growth_chance).append("\n");
        sb.append("\t- Growth Bonus: ").append(this.growth_bonus).append("\n");
        sb.append("\t- Seed Drop Chance: ").append(this.seed_drop_chance).append("\n");
        sb.append("\t- Seed Drop Bonus: ").append(this.seed_drop_bonus).append("\n");
        sb.append("\t- Grass Drop Chance: ").append(this.grass_drop_chance).append("\n");
        sb.append("\t- ").append(this.products.toString().replaceAll("\n", "\n\t").trim()).append("\n");
        sb.append("\t- ").append(this.requirement.toString().replaceAll("\n", "\n\t").trim()).append("\n");
        sb.append("\t- Particle Effect: \n\t").append(this.listToString(this.particle_effects).replaceAll("\n", "\n\t").trim()).append("\n");
        return sb.toString();
    }

    private String listToString(List<?> list) {
        return list.stream().collect(StringBuilder::new, (builder, item) -> builder.append("\n\t").append(item), StringBuilder::append).toString();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean checkMods() {
        return this.mods.stream().allMatch(mod -> AgriCore.getValidator().isValidMod((String)mod));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(AgriPlant o) {
        return this.getId().compareTo(o.getId());
    }
}

