/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriBlockCondition;
import com.agricraft.agricore.plant.AgriObject;
import com.agricraft.agricore.plant.AgriSoilCondition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class AgriRequirement {
    private final AgriSoilCondition soil_humidity;
    private final AgriSoilCondition soil_acidity;
    private final AgriSoilCondition soil_nutrients;
    private final int min_light;
    private final int max_light;
    private final double light_tolerance_factor;
    private final List<String> seasons;
    private final List<AgriBlockCondition> conditions;
    private final AgriObject fluid;

    public AgriRequirement() {
        this.soil_humidity = new AgriSoilCondition("damp", "equal", 0.15);
        this.soil_acidity = new AgriSoilCondition("neutral", "equal", 0.2);
        this.soil_nutrients = new AgriSoilCondition("medium", "equal_or_higher", 0.1);
        this.min_light = 10;
        this.max_light = 16;
        this.light_tolerance_factor = 0.5;
        this.seasons = Lists.newArrayList((Object[])new String[]{"spring", "summer", "autumn", "winter"});
        this.conditions = new ArrayList<AgriBlockCondition>();
        this.fluid = new AgriObject("fluid", "minecraft:empty");
    }

    public AgriRequirement(AgriSoilCondition soil_humidity, AgriSoilCondition soil_acidity, AgriSoilCondition soil_nutrients, int min_light, int max_light, double light_tolerance_factor, List<String> seasons, List<AgriBlockCondition> conditions, AgriObject fluid) {
        this.soil_humidity = soil_humidity;
        this.soil_acidity = soil_acidity;
        this.soil_nutrients = soil_nutrients;
        this.min_light = min_light;
        this.max_light = max_light;
        this.light_tolerance_factor = light_tolerance_factor;
        this.seasons = new ArrayList<String>(seasons);
        this.conditions = conditions;
        this.fluid = fluid;
    }

    public AgriSoilCondition getHumiditySoilCondition() {
        return this.soil_humidity;
    }

    public AgriSoilCondition getAciditySoilCondition() {
        return this.soil_acidity;
    }

    public AgriSoilCondition getNutrientSoilCondition() {
        return this.soil_nutrients;
    }

    public int getMinLight() {
        return this.min_light;
    }

    public int getMaxLight() {
        return this.max_light;
    }

    public double getLightToleranceFactor() {
        return this.light_tolerance_factor;
    }

    public List<String> getSeasons() {
        return this.seasons;
    }

    public List<AgriBlockCondition> getConditions() {
        return new ArrayList<AgriBlockCondition>(this.conditions);
    }

    public AgriObject getFluid() {
        return this.fluid;
    }

    public boolean validate() {
        if (!this.getHumiditySoilCondition().validate(value -> AgriCore.getValidator().isValidHumidity((String)value))) {
            return false;
        }
        if (!this.getAciditySoilCondition().validate(value -> AgriCore.getValidator().isValidAcidity((String)value))) {
            return false;
        }
        if (!this.getNutrientSoilCondition().validate(value -> AgriCore.getValidator().isValidNutrients((String)value))) {
            return false;
        }
        if (this.getMinLight() > this.getMaxLight()) {
            AgriCore.getCoreLogger().info("Minimum light value can not be higher than the maximum light value", new Object[0]);
            return false;
        }
        for (String season : this.getSeasons()) {
            if (AgriCore.getValidator().isValidSeason(season)) continue;
            AgriCore.getCoreLogger().info("Invalid Season: \"{0}\"", season);
            return false;
        }
        for (AgriBlockCondition condition : this.getConditions()) {
            if (condition.validate()) continue;
            AgriCore.getCoreLogger().info("Invalid Block Condition: {0}", condition);
            return false;
        }
        if (!this.getFluid().validate()) {
            AgriCore.getCoreLogger().info("Invalid Fluid Condition: {0}", this.getFluid());
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nRequirement:");
        sb.append("\n\t- Soil Humidity:");
        sb.append("\n\t\t").append(this.getHumiditySoilCondition().toString());
        sb.append("\n\t- Soil Acidity:");
        sb.append("\n\t\t").append(this.getAciditySoilCondition().toString());
        sb.append("\n\t- Soil Nutrients:");
        sb.append("\n\t\t").append(this.getNutrientSoilCondition().toString());
        sb.append("\n\t- Light:");
        sb.append("\n\t\t- Min: ").append(this.min_light);
        sb.append("\n\t\t- Max: ").append(this.max_light);
        sb.append("\n\t- Seasons: ");
        this.getSeasons().forEach(s -> sb.append("\n\t\t").append((String)s));
        sb.append("\n\t- Conditions:");
        this.getConditions().forEach(c -> sb.append("\n\t\t- ").append(c.toString().replaceAll("\n", "\n\t\t").trim()));
        return sb.toString();
    }
}

