/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.registry;

import com.agricraft.agricore.json.AgriJsonVersion;
import com.agricraft.agricore.plant.AgriSoil;
import com.agricraft.agricore.plant.versions.v2.Versions_1_16;
import com.agricraft.agricore.registry.AgriLoadableRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AgriSoils
implements AgriLoadableRegistry<AgriSoil> {
    private final Map<String, AgriSoil> soils = new HashMap<String, AgriSoil>();

    public boolean hasSoil(String id) {
        return this.soils.containsKey(id);
    }

    public boolean addSoil(AgriSoil plant) {
        return this.soils.putIfAbsent(plant.getId(), plant) == null;
    }

    public AgriSoil getSoil(String id) {
        return this.soils.get(id);
    }

    public Collection<AgriSoil> getAll() {
        return Collections.unmodifiableCollection(this.soils.values());
    }

    public void validate() {
        this.soils.entrySet().removeIf(e -> !((AgriSoil)e.getValue()).validate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nSoils:");
        for (AgriSoil plant : this.soils.values()) {
            sb.append("\n\t- Soil: ");
            sb.append(plant.toString().replaceAll("\n", "\n\t").trim());
        }
        return sb.append("\n").toString();
    }

    @Override
    public boolean acceptsElement(String filename) {
        return filename.toLowerCase().endsWith("_soil.json");
    }

    @Override
    public AgriJsonVersion<AgriSoil> getElementVersion() {
        return Versions_1_16.SOIL;
    }

    @Override
    public void registerElement(AgriSoil element) {
        this.addSoil(element);
    }

    @Override
    public void clearElements() {
        this.soils.clear();
    }

    public int hashCode() {
        return this.soils.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgriSoils other = (AgriSoils)obj;
        return this.soils.equals(other.soils);
    }
}

