/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.plant;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;

public interface IJsonPlantCallback {
    public static Optional<Factory> getCallback(String id) {
        return AgriApi.getJsonPlantCallback(id);
    }

    public static boolean registerCallback(Factory callback) {
        return AgriApi.registerJsonPlantCallback(callback);
    }

    default public int getBrightness(@Nonnull IAgriCrop crop) {
        return 0;
    }

    default public int getRedstonePower(@Nonnull IAgriCrop crop) {
        return 0;
    }

    default public void onPlanted(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
    }

    default public void onSpawned(@Nonnull IAgriCrop crop) {
    }

    default public void onGrowth(@Nonnull IAgriCrop crop) {
    }

    default public void onRemoved(@Nonnull IAgriCrop crop) {
    }

    default public void onHarvest(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
    }

    default public void onClipped(@Nonnull IAgriCrop crop, @Nonnull ItemStack clipper, @Nullable LivingEntity entity) {
    }

    default public void onBroken(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
    }

    default public void onEntityCollision(@Nonnull IAgriCrop crop, Entity entity) {
    }

    default public Optional<ActionResultType> onRightClickPre(@Nonnull IAgriCrop crop, @Nonnull ItemStack stack, @Nullable Entity entity) {
        return Optional.empty();
    }

    default public Optional<ActionResultType> onRightClickPost(@Nonnull IAgriCrop crop, @Nonnull ItemStack stack, @Nullable Entity entity) {
        return Optional.empty();
    }

    public static interface Factory {
        public String getId();

        public IJsonPlantCallback makeCallBack(JsonElement var1) throws JsonParseException;

        @Nullable
        default public Factory register() {
            if (IJsonPlantCallback.registerCallback(this)) {
                return this;
            }
            return null;
        }
    }
}

