/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.agricraft.agricore.util.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.core.BlockCropBase;
import com.infinityraider.agricraft.content.core.CropStickVariant;
import com.infinityraider.agricraft.content.core.ItemCropSticks;
import com.infinityraider.agricraft.content.core.ItemDebugger;
import com.infinityraider.agricraft.content.core.TileEntityCropPlant;
import com.infinityraider.agricraft.content.core.TileEntityCropSticks;
import com.infinityraider.agricraft.content.tools.ItemSeedBag;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockCropSticks
extends BlockCropBase<TileEntityCropSticks> {
    private static final Class<?>[] ITEM_EXCLUDES = new Class[]{IAgriRakeItem.class, IAgriClipperItem.class, IAgriTrowelItem.class, ItemSeedBag.class, ItemDebugger.class};
    public static final InfProperty<Boolean> CROSS_CROP = InfProperty.Creators.create((String)"cross_crop", (boolean)false);
    private static final InfPropertyConfiguration PROPERTIES = InfPropertyConfiguration.builder().add(CROSS_CROP).add(PLANT).add(LIGHT).fluidloggable().build();
    private static final BiFunction<BlockState, IBlockReader, TileEntityCropSticks> TILE_FACTORY = (s, w) -> new TileEntityCropSticks();
    private static final VoxelShape SHAPE_DEFAULT = Stream.of(Block.func_208617_a((double)2.0, (double)-3.0, (double)2.0, (double)3.0, (double)14.0, (double)3.0), Block.func_208617_a((double)13.0, (double)-3.0, (double)2.0, (double)14.0, (double)14.0, (double)3.0), Block.func_208617_a((double)2.0, (double)-3.0, (double)13.0, (double)3.0, (double)14.0, (double)14.0), Block.func_208617_a((double)13.0, (double)-3.0, (double)13.0, (double)14.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_CROSS_CROP = Stream.of(SHAPE_DEFAULT, Block.func_208617_a((double)0.0, (double)11.0, (double)2.0, (double)16.0, (double)12.0, (double)3.0), Block.func_208617_a((double)0.0, (double)11.0, (double)13.0, (double)16.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)11.0, (double)0.0, (double)3.0, (double)12.0, (double)16.0), Block.func_208617_a((double)13.0, (double)11.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final Map<Integer, VoxelShape> PLANT_SHAPES = Maps.newHashMap();
    private static final Map<Integer, VoxelShape> CROSS_PLANT_SHAPES = Maps.newHashMap();
    private final CropStickVariant variant;

    public static VoxelShape getPlantShape(int height) {
        return PLANT_SHAPES.computeIfAbsent(height, h -> Stream.of(SHAPE_DEFAULT, Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)h.intValue(), (double)13.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }

    public static VoxelShape getCrossPlantShape(int height) {
        return CROSS_PLANT_SHAPES.computeIfAbsent(height, h -> Stream.of(SHAPE_CROSS_CROP, Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)h.intValue(), (double)13.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }

    public BlockCropSticks(CropStickVariant variant) {
        super(variant.getId(), AbstractBlock.Properties.func_200945_a((Material)variant.getMaterial()).func_200944_c().func_226896_b_().func_235838_a_(arg_0 -> ((InfProperty)LIGHT).fetch(arg_0)));
        this.variant = variant;
    }

    public CropStickVariant getVariant() {
        return this.variant;
    }

    public boolean isVariant(ItemCropSticks sticks) {
        return this.getVariant() == sticks.getVariant();
    }

    public BiFunction<BlockState, IBlockReader, TileEntityCropSticks> getTileEntityFactory() {
        return TILE_FACTORY;
    }

    protected InfPropertyConfiguration getPropertyConfiguration() {
        return PROPERTIES;
    }

    public ItemCropSticks asItem() {
        return this.getVariant().getItem();
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (((Boolean)CROSS_CROP.fetch(state)).booleanValue()) {
            if (((Boolean)PLANT.fetch(state)).booleanValue()) {
                return BlockCropSticks.getCrossPlantShape(this.getCrop(world, pos).map(crop -> Math.max(crop.getPlant().getPlantHeight(crop.getGrowthStage()), crop.getWeeds().getPlantHeight(crop.getWeedGrowthStage()))).map(Double::intValue).orElse(0));
            }
            return SHAPE_CROSS_CROP;
        }
        if (((Boolean)PLANT.fetch(state)).booleanValue()) {
            return BlockCropSticks.getPlantShape(this.getCrop(world, pos).map(crop -> Math.max(crop.getPlant().getPlantHeight(crop.getGrowthStage()), crop.getWeeds().getPlantHeight(crop.getWeedGrowthStage()))).map(Double::intValue).orElse(0));
        }
        return SHAPE_DEFAULT;
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (((Config)AgriCraft.instance.getConfig()).cropSticksCollide()) {
            return (Boolean)CROSS_CROP.fetch(state) != false ? SHAPE_CROSS_CROP : SHAPE_DEFAULT;
        }
        return VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Override
    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCropSticks) {
            Arrays.stream(Direction.values()).filter(dir -> dir.func_176740_k().func_176722_c()).filter(dir -> pos.func_177972_a(dir).equals((Object)fromPos)).forEach(dir -> ((TileEntityCropSticks)tile).onNeighbourChange((Direction)dir, fromPos, world.func_180495_p(fromPos)));
        }
    }

    @Override
    protected boolean onFluidChanged(World world, BlockPos pos, BlockState state, Fluid oldFluid, Fluid newFluid) {
        Optional<IAgriCrop> optCrop = this.getCrop((IBlockReader)world, pos);
        boolean noMorePlant = optCrop.map(crop -> {
            if (!crop.hasPlant()) {
                return true;
            }
            IAgriGrowthResponse response = crop.getPlant().getGrowthRequirement(crop.getGrowthStage()).getFluidResponse(newFluid, crop.getStats().getStrength());
            if (response.killInstantly()) {
                response.onPlantKilled((IAgriCrop)crop);
                crop.removeGenome();
                return true;
            }
            return false;
        }).orElse(true);
        if (this.getVariant().canExistInFluid(newFluid)) {
            return false;
        }
        if (noMorePlant) {
            world.func_175656_a(pos, newFluid.func_207188_f().func_206883_i());
            if (world instanceof ServerWorld) {
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.5;
                double z = (double)pos.func_177952_p() + 0.5;
                for (int i = 0; i < 2; ++i) {
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197601_L, x + 0.25 * world.func_201674_k().nextDouble(), y, z + 0.25 * world.func_201674_k().nextDouble(), 1, 0.0, 1.0, 0.0, 0.25);
                }
                world.func_184148_a(null, x, y, z, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.2f + world.func_201674_k().nextFloat() * 0.2f, 0.9f + world.func_201674_k().nextFloat() * 0.05f);
            }
        } else {
            BlockState newState = AgriCraft.instance.getModBlockRegistry().crop_plant.func_176223_P();
            newState = BlockCropBase.PLANT.mimic(state, newState);
            newState = BlockCropBase.LIGHT.mimic(state, newState);
            newState = InfProperty.Defaults.fluidlogged().mimic(state, newState);
            world.func_175656_a(pos, newState);
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileEntityCropPlant)) {
                world.func_175656_a(pos, state);
                return false;
            }
            ((TileEntityCropPlant)tile).mimicFrom(optCrop.get());
        }
        return true;
    }

    @Override
    public ActionResultType onCropRightClicked(World world, BlockPos pos, IAgriCrop crop, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            if (crop.isCrossCrop()) {
                if (crop.setCrossCrop(false) && !player.func_184812_l_()) {
                    this.spawnItem(crop, new ItemStack((IItemProvider)this.asItem()));
                    return ActionResultType.CONSUME;
                }
            } else {
                return crop.harvest(stack -> this.spawnItem(crop, (ItemStack)stack), (LivingEntity)player);
            }
        }
        if (TypeHelper.isAnyType(heldItem.func_77973_b(), (Class[])ITEM_EXCLUDES)) {
            return ActionResultType.PASS;
        }
        if (AgriApi.getFertilizerAdapterizer().hasAdapter(heldItem)) {
            return AgriApi.getFertilizerAdapterizer().valueOf(heldItem).map(fertilizer -> {
                if (crop.acceptsFertilizer((IAgriFertilizer)fertilizer)) {
                    ActionResultType result = fertilizer.applyFertilizer(world, pos, crop, heldItem, world.func_201674_k(), (LivingEntity)player);
                    if (result.func_226246_a_()) {
                        crop.onApplyFertilizer((IAgriFertilizer)fertilizer, world.func_201674_k());
                    }
                    return result;
                }
                return ActionResultType.CONSUME;
            }).orElse(ActionResultType.PASS);
        }
        if (heldItem.func_77973_b() == this.asItem() && crop.setCrossCrop(true)) {
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(1);
            }
            this.asItem().playCropStickSound(world, pos);
            return ActionResultType.SUCCESS;
        }
        if (AgriApi.getGenomeAdapterizer().hasAdapter(heldItem)) {
            return AgriApi.getGenomeAdapterizer().valueOf(heldItem).map(seed -> {
                if (crop.plantGenome((IAgriGenome)seed, (LivingEntity)player)) {
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                    player.func_184609_a(hand);
                    return ActionResultType.CONSUME;
                }
                return ActionResultType.PASS;
            }).orElse(ActionResultType.PASS);
        }
        return crop.harvest(stack -> this.spawnItem(crop, (ItemStack)stack), (LivingEntity)player);
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        ArrayList drops = Lists.newArrayList();
        TileEntity tile = (TileEntity)context.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof IAgriCrop) {
            IAgriCrop crop = (IAgriCrop)tile;
            if (crop.hasPlant()) {
                crop.getPlant().getHarvestProducts(drops::add, crop.getGrowthStage(), crop.getStats(), context.func_216018_a().func_201674_k());
                if (crop.getGrowthStage().canDropSeed()) {
                    crop.getGenome().map(IAgriGenome::toSeedStack).ifPresent(drops::add);
                }
            }
            if (!crop.hasWeeds() || !((Config)AgriCraft.instance.getConfig()).weedsDestroyCropSticks()) {
                drops.add(new ItemStack((IItemProvider)this.asItem(), crop.isCrossCrop() ? 2 : 1));
            }
        } else {
            AgriCraft.instance.getLogger().error("Could not find IAgriCrop instance associated with crop sticks: " + context, new Object[0]);
            drops.add(new ItemStack((IItemProvider)this.asItem(), 1));
            if (((Boolean)CROSS_CROP.fetch(state)).booleanValue()) {
                drops.add(new ItemStack((IItemProvider)this.asItem(), 1));
            }
        }
        return drops;
    }
}

