/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.content.core.TileEntityCropSticks;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDynamicAgriSeed
extends ItemBase
implements IAgriSeedItem {
    private static final IAgriPlant NO_PLANT = NoPlant.getInstance();

    public static ItemStack toStack(IAgriPlant plant, int amount) {
        return ItemDynamicAgriSeed.toStack(AgriApi.getAgriGenomeBuilder(plant).build(), amount);
    }

    public static ItemStack toStack(IAgriGenome genome, int amount) {
        ItemStack stack = new ItemStack((IItemProvider)AgriCraft.instance.getModItemRegistry().seed, amount);
        CompoundNBT tag = new CompoundNBT();
        genome.writeToNBT(tag);
        stack.func_77982_d(tag);
        return stack;
    }

    public ItemDynamicAgriSeed() {
        super("agri_seed", new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT_SEED).func_200917_a(64));
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (tile instanceof TileEntityCropSticks) {
            return this.attemptSeedPlant((TileEntityCropSticks)tile, stack, player);
        }
        return AgriApi.getSoil((IBlockReader)world, pos).map(soil -> {
            BlockState newState;
            BlockPos up = pos.func_177984_a();
            TileEntity above = world.func_175625_s(up);
            if (above instanceof TileEntityCropSticks) {
                return this.attemptSeedPlant((TileEntityCropSticks)above, stack, player);
            }
            if (above == null && ((Config)AgriCraft.instance.getConfig()).allowPlantingOutsideCropSticks() && (newState = AgriCraft.instance.getModBlockRegistry().crop_plant.getStateForPlacement(world, up)) != null && world.func_180501_a(up, newState, 11)) {
                boolean success = AgriApi.getCrop((IBlockReader)world, up).map(crop -> this.getGenome(context.func_195996_i()).map(genome -> crop.plantGenome((IAgriGenome)genome, (LivingEntity)player)).map(result -> {
                    if (result.booleanValue() && (player == null || !player.func_184812_l_())) {
                        stack.func_190918_g(1);
                    }
                    return result;
                }).orElse(false)).orElse(false);
                if (success) {
                    return ActionResultType.SUCCESS;
                }
                world.func_175656_a(up, Blocks.field_150350_a.func_176223_P());
            }
            return super.func_195939_a(context);
        }).orElse(super.func_195939_a(context));
    }

    protected ActionResultType attemptSeedPlant(IAgriCrop crop, ItemStack stack, PlayerEntity player) {
        return AgriApi.getGenomeAdapterizer().valueOf(stack).map(seed -> {
            if (crop.plantGenome((IAgriGenome)seed, (LivingEntity)player)) {
                if (player != null && !player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.CONSUME;
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return this.getPlant(stack).getSeedName();
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            AgriApi.getPlantRegistry().stream().map(IAgriPlant::toItemStack).forEach(arg_0 -> items.add(arg_0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag advanced) {
        this.getStats(stack).ifPresent(stats -> stats.addTooltips(tooltip::add));
    }

    @Override
    @Nonnull
    public Optional<IAgriGenome> getGenome(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return Optional.empty();
        }
        IAgriGenome genome = AgriApi.getAgriGenomeBuilder(NO_PLANT).build();
        if (!genome.readFromNBT(tag)) {
            stack.func_77982_d(null);
            return Optional.empty();
        }
        return Optional.of(genome);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }
}

