/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.tools;

import com.google.common.collect.Lists;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.event.AgriCropEvent;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.reference.AgriToolTips;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemClipper
extends ItemBase
implements IAgriClipperItem {
    public ItemClipper() {
        super("agri_clipper", new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT).func_200917_a(1));
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.func_201670_d()) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        return AgriApi.getCrop((IBlockReader)world, pos).map(crop -> {
            if (!crop.hasPlant() || !crop.getPlant().allowsClipping(crop.getGrowthStage(), stack, (LivingEntity)player)) {
                if (player != null) {
                    player.func_145747_a(AgriToolTips.MSG_CLIPPING_IMPOSSIBLE, player.func_110124_au());
                }
                return ActionResultType.FAIL;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Clip.Pre((IAgriCrop)crop, stack, (LivingEntity)player))) {
                return ActionResultType.FAIL;
            }
            ArrayList drops = Lists.newArrayList();
            crop.getPlant().getClipProducts(drops::add, stack, crop.getGrowthStage(), crop.getStats(), world.func_201674_k());
            crop.setGrowthStage(crop.getPlant().getInitialGrowthStage());
            crop.getPlant().onClipped((IAgriCrop)crop, stack, (LivingEntity)player);
            AgriCropEvent.Clip.Post event = new AgriCropEvent.Clip.Post((IAgriCrop)crop, stack, drops, (LivingEntity)player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            event.getDrops().forEach(crop::dropItem);
            return ActionResultType.SUCCESS;
        }).orElse(ActionResultType.FAIL);
    }
}

