/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.client.IJournalDataDrawer;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.render.items.journal.JournalClientData;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerFrontPage;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerGenetics;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerGrowthReqs;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerIntroduction;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerMissing;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerMutations;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerPlant;
import com.infinityraider.agricraft.render.items.journal.JournalRenderContextInHand;
import com.infinityraider.agricraft.util.PlayerAngleLocker;
import com.infinityraider.infinitylib.modules.dynamiccamera.IDynamicCameraController;
import com.infinityraider.infinitylib.modules.dynamiccamera.ModuleDynamicCamera;
import com.infinityraider.infinitylib.modules.playeranimations.IAnimatablePlayerModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class JournalViewPointHandler
implements IDynamicCameraController {
    private static final JournalViewPointHandler INSTANCE = new JournalViewPointHandler();
    private static final Map<ResourceLocation, IJournalDataDrawer<?>> PAGE_DRAWERS = Maps.newHashMap();
    private static final int OPENING_DURATION = 20;
    public static final double DX = 0.35;
    public static final double DY = -0.95;
    public static final double DZ = 0.425;
    public static final float PITCH = 80.0f;
    public static final float YAW = 0.0f;
    private boolean offHandActive;
    private boolean mainHandActive;
    private boolean observed;
    private Vector3d observerStart;
    private Vector3d cameraPosition;
    private Vector2f cameraOrientation;
    private float yawOffset;
    private JournalClientData journal;
    private int openingCounter;
    private int openingCounterPrev;

    public static JournalViewPointHandler getInstance() {
        return INSTANCE;
    }

    private JournalViewPointHandler() {
    }

    public boolean toggle(PlayerEntity player, Hand hand) {
        if (this.isActive(hand)) {
            this.setActive(hand, false);
            if (((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, false)) {
                this.journal = null;
                return true;
            }
            this.setActive(hand, true);
            this.journal = new JournalClientData(player, hand);
        } else {
            Hand other;
            Hand hand2 = other = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
            if (!this.isActive(other)) {
                this.setActive(hand, true);
                if (((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, true)) {
                    this.journal = new JournalClientData(player, hand);
                    return true;
                }
                this.setActive(hand, false);
                this.journal = null;
            }
        }
        return false;
    }

    public void setActive(Hand hand, boolean status) {
        if (hand == Hand.MAIN_HAND) {
            this.setMainHandActive(status);
        } else {
            this.setOffHandActive(status);
        }
    }

    public void setOffHandActive(boolean status) {
        this.offHandActive = status;
        if (status) {
            PlayerAngleLocker.storePlayerAngles();
        }
    }

    public void setMainHandActive(boolean status) {
        this.mainHandActive = status;
        if (status) {
            PlayerAngleLocker.storePlayerAngles();
        }
    }

    public boolean isActive() {
        return this.isMainHandActive() || this.isOffHandActive();
    }

    public boolean isActive(Hand hand) {
        return hand == Hand.MAIN_HAND ? this.isMainHandActive() : this.isOffHandActive();
    }

    public boolean isActive(HandSide hand) {
        HandSide main = Minecraft.func_71410_x().field_71474_y.field_186715_A;
        if (main == hand) {
            return this.isMainHandActive();
        }
        return this.isOffHandActive();
    }

    public boolean isMainHandActive() {
        return this.mainHandActive;
    }

    public boolean isOffHandActive() {
        return this.offHandActive;
    }

    public boolean isObserved() {
        return this.observed;
    }

    protected PlayerEntity getObserver() {
        return AgriCraft.instance.getClientPlayer();
    }

    @Nullable
    public JournalClientData getJournalData() {
        return this.journal;
    }

    @Nullable
    public ItemStack getJournal() {
        return this.getJournalData() == null ? null : this.getJournalData().getJournalStack();
    }

    public float getOpeningProgress(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.openingCounterPrev, (float)this.openingCounter) / 20.0f;
    }

    public float getFlippingProgress(float partialTicks) {
        return this.getJournalData() == null ? 0.0f : this.getJournalData().getFlippingProgress(partialTicks);
    }

    public void renderViewedPageLeft(JournalRenderContextInHand context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        if (this.getJournalData() != null) {
            IAgriJournalItem.IPage page = this.getJournalData().getCurrentPage();
            JournalViewPointHandler.getPageDrawer(page).drawLeftSheet(page, context, transforms, stack, journal);
        }
    }

    public void renderViewedPageRight(JournalRenderContextInHand context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        if (this.getJournalData() != null) {
            IAgriJournalItem.IPage page = this.getJournalData().getCurrentPage();
            JournalViewPointHandler.getPageDrawer(page).drawRightSheet(page, context, transforms, stack, journal);
        }
    }

    public void renderFlippedPageLeft(JournalRenderContextInHand context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        if (this.getJournalData() != null) {
            IAgriJournalItem.IPage page = this.getJournalData().getFlippedPage();
            JournalViewPointHandler.getPageDrawer(page).drawLeftSheet(page, context, transforms, stack, journal);
        }
    }

    public void renderFlippedPageRight(JournalRenderContextInHand context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        if (this.getJournalData() != null) {
            IAgriJournalItem.IPage page = this.getJournalData().getFlippedPage();
            JournalViewPointHandler.getPageDrawer(page).drawRightSheet(page, context, transforms, stack, journal);
        }
    }

    public int getTransitionDuration() {
        return ((Config)AgriCraft.instance.getConfig()).journalAnimationDuration();
    }

    public void onCameraActivated() {
        this.observerStart = this.getObserver().func_213303_ch();
    }

    public void onObservationStart() {
        this.observed = true;
    }

    public void onObservationEnd() {
        this.observed = false;
    }

    public void onCameraDeactivated() {
        this.setMainHandActive(false);
        this.setOffHandActive(false);
        this.observerStart = null;
        this.cameraPosition = null;
        this.cameraOrientation = null;
        this.journal = null;
    }

    public boolean shouldContinueObserving() {
        return this.observerStart != null && this.observerStart.equals((Object)this.getObserver().func_213303_ch());
    }

    public Vector3d getObserverPosition() {
        if (this.cameraPosition == null || this.yawOffset != this.getObserver().field_70761_aq) {
            this.cameraPosition = this.calculateObserverPosition(((IProxy)AgriCraft.instance.proxy()).getFieldOfView());
        }
        return this.cameraPosition;
    }

    protected Vector3d calculateObserverPosition(double fov) {
        double dz;
        double dx;
        double d = 0.175 / Math.tan(1.5707963267948966 * fov / 360.0);
        double dy = -0.95 + d * (double)MathHelper.func_76126_a((float)1.3962635f);
        double dHor = d * (double)MathHelper.func_76134_b((float)1.3962635f);
        float yaw = this.getObserverOrientation().field_189983_j;
        double cosYaw = MathHelper.func_76134_b((float)((float)Math.PI * yaw / 180.0f));
        double sinYaw = MathHelper.func_76126_a((float)((float)Math.PI * yaw / 180.0f));
        if (this.isActive(HandSide.RIGHT)) {
            dx = dHor * cosYaw - 0.35 * cosYaw - 0.425 * sinYaw;
            dz = dHor * sinYaw - 0.35 * sinYaw + 0.425 * cosYaw;
        } else {
            dx = dHor * cosYaw + 0.35 * cosYaw - 0.425 * sinYaw;
            dz = dHor * sinYaw + 0.35 * sinYaw + 0.425 * cosYaw;
        }
        return this.getObserver().func_213303_ch().func_72441_c(dx, dy + (double)this.getObserver().func_70047_e(), dz);
    }

    public Vector2f getObserverOrientation() {
        if (this.cameraOrientation == null || this.yawOffset != this.getObserver().field_70761_aq) {
            this.cameraOrientation = this.calculateObserverOrientation();
        }
        return this.cameraOrientation;
    }

    protected Vector2f calculateObserverOrientation() {
        float yaw = this.yawOffset = this.getObserver().field_70761_aq;
        if (this.isActive(HandSide.RIGHT)) {
            yaw += 0.0f;
        } else if (this.isActive(HandSide.LEFT)) {
            yaw -= 0.0f;
        }
        return new Vector2f(80.0f, yaw);
    }

    public void onFieldOfViewChanged(float fov) {
        this.cameraPosition = this.calculateObserverPosition(fov);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.func_130014_f_().func_201670_d()) {
            return;
        }
        if (this.isActive()) {
            if (this.isOffHandActive()) {
                if (!(this.getObserver().func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof IAgriJournalItem)) {
                    ((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, false);
                    this.setOffHandActive(false);
                    this.journal = null;
                    return;
                }
            } else if (this.isMainHandActive() && !(this.getObserver().func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof IAgriJournalItem)) {
                ((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, false);
                this.setMainHandActive(false);
                this.journal = null;
                return;
            }
            boolean up = Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d();
            boolean down = Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d();
            boolean left = Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d();
            boolean right = Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
            if (up || down || left || right) {
                ModuleDynamicCamera.getInstance().stopObserving();
            }
            PlayerAngleLocker.forcePlayerAngles();
        }
        this.openingCounterPrev = this.openingCounter;
        if (this.isObserved()) {
            this.openingCounter = this.openingCounter < 20 ? this.openingCounter + 1 : 20;
        } else {
            int n = this.openingCounter = this.openingCounter > 0 ? this.openingCounter - 1 : 0;
        }
        if (this.getJournalData() != null) {
            this.getJournalData().tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        if (this.isActive()) {
            if (this.getJournalData() != null) {
                if (event.getScrollDelta() < 0.0) {
                    this.getJournalData().incrementPage();
                } else if (event.getScrollDelta() > 0.0) {
                    this.getJournalData().decrementPage();
                }
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseClick(InputEvent.ClickInputEvent event) {
        if (this.isActive() && !event.isUseItem()) {
            event.setSwingHand(false);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (event.getPlayer() == AgriCraft.instance.getClientPlayer() && event.getRenderer().func_217764_d() instanceof IAnimatablePlayerModel) {
            IAnimatablePlayerModel model = (IAnimatablePlayerModel)event.getRenderer().func_217764_d();
            model.setDoArmWobble(!this.isActive());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMovement(InputUpdateEvent event) {
        if (this.isActive()) {
            event.getMovementInput().field_228350_h_ = false;
            event.getMovementInput().field_78901_c = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGuiOpened(GuiOpenEvent event) {
        if (this.isActive() && event.getGui() != null) {
            if (event.getGui() instanceof ChatScreen) {
                return;
            }
            ModuleDynamicCamera.getInstance().stopObserving();
            if (event.getGui() instanceof IngameMenuScreen) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    public static void registerJournalDataDrawer(IJournalDataDrawer<?> drawer) {
        PAGE_DRAWERS.put(drawer.getId(), drawer);
    }

    public static <P extends IAgriJournalItem.IPage> IJournalDataDrawer<P> getPageDrawer(P page) {
        return PAGE_DRAWERS.getOrDefault(page.getDataDrawerId(), JournalDataDrawerMissing.INSTANCE);
    }

    static {
        JournalViewPointHandler.registerJournalDataDrawer(new JournalDataDrawerFrontPage());
        JournalViewPointHandler.registerJournalDataDrawer(new JournalDataDrawerGenetics());
        JournalViewPointHandler.registerJournalDataDrawer(new JournalDataDrawerGrowthReqs());
        JournalViewPointHandler.registerJournalDataDrawer(new JournalDataDrawerIntroduction());
        JournalViewPointHandler.registerJournalDataDrawer(new JournalDataDrawerMutations());
        JournalViewPointHandler.registerJournalDataDrawer(new JournalDataDrawerPlant());
    }
}

