/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriPlant;
import com.agricraft.agricore.plant.AgriWeed;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.render.blocks.TileEntityIrrigationChannelRenderer;
import java.util.stream.Stream;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ModelAndTextureHandler {
    private static final ModelAndTextureHandler INSTANCE = new ModelAndTextureHandler();

    public static ModelAndTextureHandler getInstance() {
        return INSTANCE;
    }

    private ModelAndTextureHandler() {
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            Stream.concat(AgriCore.getPlants().getAllElements().stream().map(AgriPlant::getTexture), AgriCore.getWeeds().getAllElements().stream().map(AgriWeed::getTexture)).flatMap(tex -> tex.getAllTextures().stream().distinct()).map(ResourceLocation::new).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }

    @SubscribeEvent
    public void onModelLoadEvent(ModelRegistryEvent event) {
        AgriCore.getPlants().getAllElements().stream().map(AgriPlant::getSeedModel).map(this::toResourceLocation).forEach(ModelLoader::addSpecialModel);
        ModelLoader.addSpecialModel((ResourceLocation)NoPlant.getInstance().getSeedModel());
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(AgriCraft.instance.getModId(), "item/agri_seed_bag_empty"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(AgriCraft.instance.getModId(), "item/agri_seed_bag_partial"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(AgriCraft.instance.getModId(), "item/agri_seed_bag_full"));
        ModelLoader.addSpecialModel((ResourceLocation)TileEntityIrrigationChannelRenderer.MODEL_HANDWHEEL);
    }

    private ResourceLocation toResourceLocation(String string) {
        if (string.contains("#")) {
            return new ModelResourceLocation(string);
        }
        return new ResourceLocation(string);
    }
}

