/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.crop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.config.Config;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;

public final class IncrementalGrowthLogic {
    private static final Map<Integer, List<IAgriGrowthStage>> CACHE = Maps.newHashMap();

    public static List<IAgriGrowthStage> getOrGenerateStages(int amount) {
        return CACHE.computeIfAbsent(amount, value -> {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (int i = 0; i < value; ++i) {
                builder.add((Object)new Stage(i, (int)value));
            }
            return builder.build();
        });
    }

    public static int getGrowthIndex(IAgriGrowthStage stage) {
        if (stage instanceof Stage) {
            return ((Stage)stage).stage;
        }
        return -1;
    }

    private IncrementalGrowthLogic() {
    }

    private static class Stage
    implements IAgriGrowthStage {
        private final int stage;
        private final int total;
        private final double percentage;
        private final boolean mature;
        private final String id;
        private IAgriGrowthStage next;
        private IAgriGrowthStage prev;

        private Stage(int stage, int total) {
            this.stage = stage;
            this.total = total;
            this.percentage = ((double)this.stage + 1.0) / (double)this.total;
            this.mature = stage >= total - 1;
            this.id = "agri_incremental_" + (this.stage + 1) + "/" + this.total;
        }

        @Override
        public boolean isMature() {
            return this.isFinal();
        }

        @Override
        public boolean isFinal() {
            return this.mature;
        }

        @Override
        public boolean canDropSeed() {
            return this.isFinal() || !((Config)AgriCraft.instance.getConfig()).onlyMatureSeedDrops();
        }

        @Override
        @Nonnull
        public IAgriGrowthStage getNextStage(IAgriCrop crop, Random random) {
            if (this.next == null) {
                this.next = this.isFinal() ? this : (IAgriGrowthStage)((List)CACHE.get(this.total)).get(this.stage + 1);
            }
            return this.next;
        }

        @Override
        @Nonnull
        public IAgriGrowthStage getPreviousStage(IAgriCrop crop, Random random) {
            if (this.prev == null) {
                this.prev = this.stage <= 0 ? this : (IAgriGrowthStage)((List)CACHE.get(this.total)).get(this.stage - 1);
            }
            return this.prev;
        }

        @Override
        public double growthPercentage() {
            return this.percentage;
        }

        @Override
        @Nonnull
        public String getId() {
            return this.id;
        }
    }
}

