/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationEngine;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationHandler;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.genetics.IMutator;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.impl.v1.genetics.AgriMutationEngine;
import com.infinityraider.agricraft.impl.v1.genetics.AgriMutationRegistry;
import com.infinityraider.agricraft.impl.v1.stats.AgriStatRegistry;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.Tuple;

public final class AgriMutationHandler
implements IAgriMutationHandler {
    private static final AgriMutationHandler INSTANCE = new AgriMutationHandler();
    private final IAgriMutationEngine defaultEngine = new AgriMutationEngine();
    private final IMutator<IAgriPlant> defaultPlantMutator = new AgriPlantMutator();
    private final IMutator<Integer> defaultStatMutator = new AgriStatMutator();
    private IAgriMutationEngine engine;
    private IMutator<IAgriPlant> plantMutator;
    private IMutator<Integer> statMutator;

    public static AgriMutationHandler getInstance() {
        return INSTANCE;
    }

    private AgriMutationHandler() {
        this.setActiveMutationEngine(this.getDefaultMutationEngine()).setActivePlantMutator(this.getDefaultPlantMutator()).setActiveStatMutator(this.getDefaultStatMutator());
    }

    @Override
    public IAgriMutationHandler setActiveMutationEngine(IAgriMutationEngine engine) {
        this.engine = engine;
        return this;
    }

    @Override
    public IAgriMutationEngine getActiveMutationEngine() {
        return this.engine;
    }

    @Override
    public IAgriMutationEngine getDefaultMutationEngine() {
        return this.defaultEngine;
    }

    @Override
    public IAgriMutationHandler setActivePlantMutator(IMutator<IAgriPlant> mutator) {
        this.plantMutator = mutator;
        return this;
    }

    @Override
    public IMutator<IAgriPlant> getActivePlantMutator() {
        return this.plantMutator;
    }

    @Override
    public IMutator<IAgriPlant> getDefaultPlantMutator() {
        return this.defaultPlantMutator;
    }

    @Override
    public IAgriMutationHandler setActiveStatMutator(IMutator<Integer> mutator) {
        this.statMutator = mutator;
        return this;
    }

    @Override
    public IMutator<Integer> getActiveStatMutator() {
        return this.statMutator;
    }

    @Override
    public IMutator<Integer> getDefaultStatMutator() {
        return this.defaultStatMutator;
    }

    public static class AgriStatMutator
    implements IMutator<Integer> {
        @Override
        public IAgriGenePair<Integer> pickOrMutate(IAgriGene<Integer> gene, IAllele<Integer> first, IAllele<Integer> second, Tuple<IAgriGenome, IAgriGenome> parents, Random random) {
            IAgriStat mutativity = AgriStatRegistry.getInstance().mutativityStat();
            return gene.generateGenePair(this.rollAndExecuteMutation(gene, first, mutativity, ((IAgriGenome)parents.func_76341_a()).getStats().getMutativity(), random), this.rollAndExecuteMutation(gene, second, mutativity, ((IAgriGenome)parents.func_76340_b()).getStats().getMutativity(), random));
        }

        protected IAllele<Integer> rollAndExecuteMutation(IAgriGene<Integer> gene, IAllele<Integer> allel, IAgriStat mutativity, int statValue, Random random) {
            int max = mutativity.getMax();
            if (random.nextInt(max) < statValue) {
                int delta = random.nextInt(max) < (max + statValue) / 2 ? 1 : -1;
                return gene.getAllele(allel.trait() + delta);
            }
            return allel;
        }
    }

    public static class AgriPlantMutator
    implements IMutator<IAgriPlant> {
        @Override
        public IAgriGenePair<IAgriPlant> pickOrMutate(IAgriGene<IAgriPlant> gene, IAllele<IAgriPlant> first, IAllele<IAgriPlant> second, Tuple<IAgriGenome, IAgriGenome> parents, Random random) {
            return AgriMutationRegistry.getInstance().getMutationsFromParents(first.trait(), second.trait()).sorted((m1, m2) -> m1 == m2 ? 0 : (random.nextBoolean() ? -1 : 1)).findAny().flatMap(mutation -> Optional.ofNullable(mutation.getChance() > random.nextDouble() ? mutation.getChild() : null)).map(plant -> gene.generateGenePair(gene.getAllele((IAgriPlant)plant), random.nextBoolean() ? first : second)).orElse(gene.generateGenePair(first, second));
        }
    }
}

