/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.plant;

import com.infinityraider.agricraft.api.v1.event.AgriRegistryEvent;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlantRegistry;
import com.infinityraider.agricraft.impl.v1.AgriRegistryAbstract;
import com.infinityraider.agricraft.impl.v1.crop.AgriGrowthRegistry;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AgriPlantRegistry
extends AgriRegistryAbstract<IAgriPlant>
implements IAgriPlantRegistry {
    public static final IAgriPlant NO_PLANT = NoPlant.getInstance();
    private static final AgriPlantRegistry INSTANCE = new AgriPlantRegistry();

    public static AgriPlantRegistry getInstance() {
        return INSTANCE;
    }

    private AgriPlantRegistry() {
        this.directAdd(NO_PLANT);
    }

    @Override
    public boolean add(@Nullable IAgriPlant object) {
        if (object == null) {
            return false;
        }
        boolean result = super.add(object);
        if (result) {
            object.getGrowthStages().forEach(stage -> AgriGrowthRegistry.getInstance().add(stage));
        }
        return result;
    }

    @Override
    public boolean remove(@Nullable IAgriPlant element) {
        return NO_PLANT != element && super.remove(element);
    }

    @Override
    @Nonnull
    public Stream<IAgriPlant> stream() {
        return super.stream().filter(IAgriPlant::isPlant);
    }

    @Override
    @Nullable
    protected AgriRegistryEvent<IAgriPlant> createEvent(IAgriPlant element) {
        return new AgriRegistryEvent.Plant(this, element);
    }

    @Override
    public IAgriPlant getNoPlant() {
        return NO_PLANT;
    }
}

