/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.plant;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class JsonPlantCallbackManager {
    private static final String ID = "id";
    private static final Map<String, IJsonPlantCallback.Factory> callbacks = Maps.newConcurrentMap();

    public static Optional<IJsonPlantCallback.Factory> get(String id) {
        return Optional.ofNullable(callbacks.get(id));
    }

    public static Optional<IJsonPlantCallback.Factory> get(JsonElement json) {
        JsonObject obj;
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return JsonPlantCallbackManager.get(primitive.getAsString());
        }
        if (json instanceof JsonObject && (obj = (JsonObject)json).has(ID)) {
            return JsonPlantCallbackManager.get(obj.get(ID).getAsString());
        }
        return Optional.empty();
    }

    public static boolean register(IJsonPlantCallback.Factory callback) {
        Objects.requireNonNull(callback);
        Preconditions.checkArgument((!callbacks.containsKey(callback.getId()) ? 1 : 0) != 0, (Object)("Can not create two callbacks with identical ids:" + callback.getId()));
        if (callbacks.containsKey(callback.getId())) {
            return false;
        }
        callbacks.put(callback.getId(), callback);
        return true;
    }

    private JsonPlantCallbackManager() {
    }
}

