/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.agrigui.analyzer;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.impl.v1.genetics.GeneSpecies;
import com.infinityraider.agricraft.plugins.agrigui.analyzer.SeedAnalyzerContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

@ParametersAreNonnullByDefault
public class SeedAnalyzerScreen
extends ContainerScreen<SeedAnalyzerContainer> {
    private final ResourceLocation GUI = new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/seed_analyzer_gui.png");
    private final ITextComponent TEXT_SEPARATOR = new StringTextComponent("-");
    private int geneIndex;

    public SeedAnalyzerScreen(SeedAnalyzerContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 186;
        this.field_147000_g = 186;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.geneIndex = 0;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.GUI);
        int relX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int relY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_238474_b_(matrixStack, relX + 25, relY + 70, 186, 73, 18, 18);
        this.func_238474_b_(matrixStack, relX + 13, relY + 25, 0, 186, 56, 56);
        List<IAgriGenePair<?>> genes = ((SeedAnalyzerContainer)this.field_147002_h).getGeneToRender();
        int geneSize = genes.size();
        if (geneSize > 7) {
            int upXOffset = SeedAnalyzerScreen.hoverUpButton(relX, relY, mouseX, mouseY) ? 195 : 186;
            this.func_238474_b_(matrixStack, relX + 67, relY + 26, upXOffset, 91, 9, 9);
            int downXOffset = SeedAnalyzerScreen.hoverDownButton(relX, relY, mouseX, mouseY) ? 195 : 186;
            this.func_238474_b_(matrixStack, relX + 67, relY + 90, downXOffset, 100, 9, 9);
        }
        if (!genes.isEmpty()) {
            int DNA_X = relX + 90;
            int yy = relY + 26;
            for (int i = 0; i < geneSize; ++i) {
                if (!(genes.get(i).getGene() instanceof GeneSpecies)) continue;
                IAgriGenePair<?> pair = genes.remove(i);
                IFormattableTextComponent domText = pair.getDominant().getTooltip();
                IFormattableTextComponent recText = pair.getRecessive().getTooltip();
                int domw = this.field_230712_o_.func_78256_a(domText.getString());
                int middle = relX + this.field_146999_f / 2;
                int sepLength = this.field_230712_o_.func_78256_a(this.TEXT_SEPARATOR.getString());
                this.field_230712_o_.func_243248_b(matrixStack, this.TEXT_SEPARATOR, (float)middle - (float)sepLength / 2.0f, (float)(relY + 16), 0);
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)domText, (float)(middle - domw) - (float)sepLength / 2.0f - 1.0f, (float)(relY + 16), 0);
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)recText, (float)middle + (float)sepLength / 2.0f + 1.0f, (float)(relY + 16), 0);
                break;
            }
            int[] lineAmount = new int[]{3, 2, 2, 3, 2, 3};
            int[] lineStart = new int[]{0, 15, 25, 35, 50, 60};
            int i = this.geneIndex;
            int lineIndex = 0;
            while (i < this.geneIndex + 6) {
                IAgriGenePair<?> pair = genes.get(i);
                Vector3f[] colors = new Vector3f[]{pair.getGene().getDominantColor(), pair.getGene().getRecessiveColor()};
                for (int j = 0; j < 2; ++j) {
                    int argb = 0xFF000000 | ((int)(colors[j].func_195899_a() * 255.0f) & 0xFF) << 16 | ((int)(colors[j].func_195900_b() * 255.0f) & 0xFF) << 8 | (int)(colors[j].func_195902_c() * 255.0f) & 0xFF;
                    for (int k = 0; k < lineAmount[lineIndex]; ++k) {
                        this.func_238465_a_(matrixStack, DNA_X + 9 * j, DNA_X + 9 + 8 * j, relY + 26 + lineStart[lineIndex] + k * 5, argb);
                    }
                }
                IFormattableTextComponent geneText = pair.getGene().getGeneDescription();
                IFormattableTextComponent domText = pair.getDominant().getTooltip();
                IFormattableTextComponent recText = pair.getRecessive().getTooltip();
                int domw = this.field_230712_o_.func_78256_a(domText.getString());
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)geneText, (float)(DNA_X + 36), (float)yy, 0);
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)domText, (float)(DNA_X - domw - 1), (float)yy, 0);
                this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)recText, (float)(DNA_X + 21), (float)yy, 0);
                this.field_230712_o_.getClass();
                yy += 9 + 4;
                ++i;
                ++lineIndex;
            }
            this.field_230706_i_.func_110434_K().func_110577_a(this.GUI);
            this.func_238474_b_(matrixStack, DNA_X, relY + 26, 186, 0, 19, 73);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.field_238742_p_ + 5.0f, (float)this.field_238743_q_, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_ + 5.0f, (float)this.field_238745_s_, 0x404040);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        List<IAgriGenePair<?>> genes = ((SeedAnalyzerContainer)this.field_147002_h).getGeneToRender();
        int maxIndex = genes.size() - 1;
        if (maxIndex > 6) {
            int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
            int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
            if (SeedAnalyzerScreen.hoverUpButton(startX, startY, (int)mouseX, (int)mouseY) && this.geneIndex > 0) {
                --this.geneIndex;
            }
            if (SeedAnalyzerScreen.hoverDownButton(startX, startY, (int)mouseX, (int)mouseY) && maxIndex - this.geneIndex > 6) {
                ++this.geneIndex;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        List<IAgriGenePair<?>> genes = ((SeedAnalyzerContainer)this.field_147002_h).getGeneToRender();
        int maxIndex = genes.size() - 1;
        if (maxIndex > 6) {
            if (delta < 0.0) {
                if (maxIndex - this.geneIndex > 6) {
                    ++this.geneIndex;
                }
            } else if (delta > 0.0 && this.geneIndex > 0) {
                --this.geneIndex;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    private static boolean hoverUpButton(int startX, int startY, int mouseX, int mouseY) {
        return startX + 67 <= mouseX && mouseX <= startX + 67 + 9 && startY + 26 <= mouseY && mouseY <= startY + 26 + 9;
    }

    private static boolean hoverDownButton(int startX, int startY, int mouseX, int mouseY) {
        return startX + 67 <= mouseX && mouseX <= startX + 67 + 9 && startY + 90 <= mouseY && mouseY <= startY + 90 + 9;
    }
}

