/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.agrigui.journal;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.handler.JournalViewPointHandler;
import com.infinityraider.agricraft.plugins.agrigui.journal.JournalScreenContext;
import com.infinityraider.agricraft.render.items.journal.JournalClientData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

@ParametersAreNonnullByDefault
public class JournalScreen
extends Screen {
    private static final ResourceLocation PAGE_BACKGROUND = new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/journal_background.png");
    private static final int PAGE_WIDTH = 292;
    private static final int PAGE_HEIGHT = 230;
    private static final int ARROW_LEFT_X = 29;
    private static final int ARROW_LEFT_Y = 205;
    private static final int ARROW_RIGHT_X = 245;
    private static final int ARROW_RIGHT_Y = 205;
    private PageButton buttonNextPage;
    private PageButton buttonPreviousPage;
    private final JournalClientData journalData;
    private final ItemStack journal;
    private static final JournalScreenContext CONTEXT_RIGHT = new JournalScreenContext(145, 0);
    private static final JournalScreenContext CONTEXT_LEFT = new JournalScreenContext(8, 7);

    public JournalScreen(ITextComponent name, PlayerEntity player, Hand hand) {
        super(name);
        this.journal = player.func_184586_b(hand);
        this.journalData = new JournalClientData(player, hand);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int renderX = (this.field_230708_k_ - 292) / 2;
        int renderY = (this.field_230709_l_ - 230) / 2;
        this.buttonNextPage = (PageButton)this.func_230480_a_((Widget)new PageButton(renderX + 245, renderY + 205, false, button -> this.nextPage()));
        this.buttonPreviousPage = (PageButton)this.func_230480_a_((Widget)new PageButton(renderX + 29, renderY + 205, true, button -> this.previousPage()));
        this.updateButtons();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PAGE_BACKGROUND);
        int renderX = (this.field_230708_k_ - 292) / 2;
        int renderY = (this.field_230709_l_ - 230) / 2;
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)renderX, (int)renderY, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)292, (int)230, (int)292, (int)292);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        IAgriJournalItem.IPage page = this.journalData.getCurrentPage();
        CONTEXT_RIGHT.setRenderXY(renderX, renderY);
        CONTEXT_LEFT.setRenderXY(renderX, renderY);
        JournalViewPointHandler.getPageDrawer(page).drawLeftSheet(page, CONTEXT_LEFT, matrixStack, this.journal, (IAgriJournalItem)this.journal.func_77973_b());
        JournalViewPointHandler.getPageDrawer(page).drawRightSheet(page, CONTEXT_RIGHT, matrixStack, this.journal, (IAgriJournalItem)this.journal.func_77973_b());
        JournalViewPointHandler.getPageDrawer(page).drawTooltipLeft(page, CONTEXT_LEFT, matrixStack, mouseX - renderX - 8, mouseY - renderY - 7);
        JournalViewPointHandler.getPageDrawer(page).drawTooltipRight(page, CONTEXT_RIGHT, matrixStack, mouseX - renderX - 145, mouseY - renderY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.previousPage();
        } else if (delta < 0.0) {
            this.nextPage();
        }
        return true;
    }

    private void previousPage() {
        this.journalData.decrementPage();
        this.journalData.getJournal().setCurrentPageIndex(this.journal, this.journalData.getPageIndex() - 1);
        this.updateButtons();
    }

    private void nextPage() {
        this.journalData.incrementPage();
        this.journalData.getJournal().setCurrentPageIndex(this.journal, this.journalData.getPageIndex() + 1);
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_230693_o_ = this.buttonNextPage.field_230694_p_ = this.journalData.getPageIndex() < this.journalData.getJournal().getPages(this.journal).size() - 1;
        this.buttonPreviousPage.field_230693_o_ = this.buttonPreviousPage.field_230694_p_ = this.journalData.getPageIndex() > 0;
    }

    private static class PageButton
    extends Button {
        private static final int ARROW_WIDTH = 18;
        private static final int ARROW_HEIGHT = 10;
        private final boolean isPrevious;

        public PageButton(int x, int y, boolean isPrevious, Button.IPressable onPress) {
            super(x, y, 18, 10, StringTextComponent.field_240750_d_, onPress);
            this.isPrevious = isPrevious;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PAGE_BACKGROUND);
            int xOffset = 0;
            if (this.func_230449_g_()) {
                xOffset += 18;
            }
            int yOffset = 252;
            if (this.isPrevious) {
                yOffset += 10;
            }
            PageButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)this.func_230927_p_(), (float)xOffset, (float)yOffset, (int)18, (int)10, (int)292, (int)292);
        }

        public void func_230988_a_(SoundHandler handler) {
            handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
        }
    }
}

