/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.agrigui.journal;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.client.IJournalDataDrawer;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class JournalScreenContext
implements IJournalDataDrawer.IPageRenderContext,
IRenderUtilities {
    private static final int PAGE_WIDTH = 125;
    private static final int PAGE_HEIGHT = 180;
    private static final ResourceLocation FONT = new ResourceLocation(AgriCraft.instance.getModId(), "unicode_font");
    private final int baseX;
    private final int baseY;
    private int renderX;
    private int renderY;

    public JournalScreenContext(int baseX, int baseY) {
        this.baseX = baseX;
        this.baseY = baseY;
    }

    public void setRenderXY(int x, int y) {
        this.renderX = x;
        this.renderY = y;
    }

    @Override
    public void draw(MatrixStack transforms, TextureAtlasSprite texture, float x, float y, float w, float h, float r, float g, float b, float a) {
        this.bindTextureAtlas();
        this.draw(transforms, x, y, w, h, texture.func_94209_e(), texture.func_94206_g(), texture.func_94212_f(), texture.func_94210_h(), r, g, b, a);
    }

    @Override
    public TextureAtlasSprite getSprite(ResourceLocation texture) {
        return super.getSprite(texture);
    }

    @Override
    public int getPageWidth() {
        return 125;
    }

    @Override
    public int getPageHeight() {
        return 180;
    }

    @Override
    public void drawFullPageTexture(MatrixStack transforms, ResourceLocation texture) {
        this.draw(transforms, texture, 8.0f, 25.0f, 128.0f, 192.0f);
    }

    @Override
    public void draw(MatrixStack transforms, ResourceLocation texture, float x, float y, float w, float h, float u1, float v1, float u2, float v2) {
        this.bindTexture(texture);
        this.draw(transforms, x, y, w, h, u1, v1, u2, v2, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void draw(MatrixStack transforms, float x, float y, float w, float h, float u1, float v1, float u2, float v2, float r, float g, float b, float a) {
        this.drawColored(transforms, x, x + w, y, y + h, u1, u2, v1, v2, r, g, b, a);
    }

    @Override
    public float drawText(MatrixStack matrixStack, ITextComponent text, float x, float y, float scale) {
        matrixStack.func_227860_a_();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        matrixStack.func_227862_a_(scale += 0.3f, scale, scale);
        float[] dy = new float[]{0.0f};
        float finalScale = scale;
        fontRenderer.func_238425_b_((ITextProperties)text.func_230532_e_().func_240703_c_(Style.field_240709_b_.func_240719_a_(FONT)), (int)(125.0f / scale)).forEach(line -> {
            fontRenderer.func_238422_b_(matrixStack, line, ((float)(this.baseX + this.renderX) + x) / finalScale, ((float)(this.baseY + this.renderY) + y + dy[0]) / finalScale, 0);
            dy[0] = dy[0] + 6.2f;
        });
        matrixStack.func_227865_b_();
        return dy[0] * scale;
    }

    @Override
    public void drawItem(MatrixStack transforms, ItemStack item, float x, float y) {
        Minecraft.func_71410_x().func_175599_af().func_175042_a(item, (int)x + this.baseX + this.renderX, (int)y + this.baseY + this.renderY);
    }

    @Override
    public void drawTooltip(MatrixStack transforms, List<ITextComponent> textLines, float x, float y) {
        GuiUtils.drawHoveringText((MatrixStack)transforms, textLines, (int)((int)(x + (float)this.baseX + (float)this.renderX)), (int)((int)y + this.baseY + this.renderY), (int)Minecraft.func_71410_x().func_228018_at_().func_198107_o(), (int)Minecraft.func_71410_x().func_228018_at_().func_198087_p(), (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
    }

    private void drawColored(MatrixStack matrixStack, float x1, float x2, float y1, float y2, float minU, float maxU, float minV, float maxV, float r, float g, float b, float a) {
        x1 += (float)(this.baseX + this.renderX);
        x2 += (float)(this.baseX + this.renderX);
        y1 += (float)(this.baseY + this.renderY);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(matrix4f, x1, y2 += (float)(this.baseY + this.renderY), 5.0f).func_225583_a_(minU, maxV).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, x2, y2, 5.0f).func_225583_a_(maxU, maxV).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, x2, y1, 5.0f).func_225583_a_(maxU, minV).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, x1, y1, 5.0f).func_225583_a_(minU, minV).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

