/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.minecraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FungusBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonPlantCallBackFungus
implements IJsonPlantCallback {
    public static final String ID = AgriCraft.instance.getModId() + ":fungus";
    private static final String FUNGUS = "fungus";
    private static final IJsonPlantCallback.Factory FACTORY = new IJsonPlantCallback.Factory(){

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public IJsonPlantCallback makeCallBack(JsonElement json) throws JsonParseException {
            if (json instanceof JsonObject) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.has(JsonPlantCallBackFungus.FUNGUS)) {
                    Block fungus = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(obj.get(JsonPlantCallBackFungus.FUNGUS).getAsString()));
                    if (fungus instanceof FungusBlock) {
                        return new JsonPlantCallBackFungus((FungusBlock)fungus);
                    }
                    throw new JsonParseException("Invalid fungus id.");
                }
                throw new JsonParseException("Json object does not contain a \"fungus\" field.");
            }
            throw new JsonParseException("Not a json object.");
        }
    };
    private final FungusBlock fungus;

    public static IJsonPlantCallback.Factory getFactory() {
        return FACTORY;
    }

    private JsonPlantCallBackFungus(FungusBlock fungus) {
        this.fungus = fungus;
    }

    @Override
    public Optional<ActionResultType> onRightClickPre(@Nonnull IAgriCrop crop, @Nonnull ItemStack stack, @Nullable Entity entity) {
        World world = crop.world();
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        if (stack.func_77973_b() != Items.field_196106_bc) {
            return Optional.empty();
        }
        if (world == null) {
            return Optional.empty();
        }
        if (!crop.isMature()) {
            return Optional.empty();
        }
        if (!this.fungus.func_176473_a((IBlockReader)world, crop.getPosition(), crop.getBlockState(), world.func_201670_d())) {
            return Optional.empty();
        }
        if (!this.fungus.func_180670_a(world, world.func_201674_k(), crop.getPosition(), crop.getBlockState())) {
            return Optional.empty();
        }
        if (world instanceof ServerWorld) {
            this.fungus.func_225535_a_((ServerWorld)world, world.func_201674_k(), crop.getPosition(), crop.getBlockState());
            world.func_217379_c(2005, crop.getPosition(), 0);
        }
        return Optional.of(ActionResultType.SUCCESS);
    }
}

